/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.json;

import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.utils.ReflectionUtils;
import com.google.gson.JsonElement;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0013\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/utils/json/Shimmy;", "", "source", "Ljava/lang/reflect/Field;", "field", "<init>", "(Ljava/lang/Object;Ljava/lang/reflect/Field;)V", "get", "()Ljava/lang/Object;", "value", "", "set", "(Ljava/lang/Object;)V", "Lcom/google/gson/JsonElement;", "getJson", "()Lcom/google/gson/JsonElement;", "element", "setJson", "(Lcom/google/gson/JsonElement;)V", "Ljava/lang/Object;", "getSource", "Ljava/lang/reflect/Field;", "getField", "()Ljava/lang/reflect/Field;", "Ljava/lang/Class;", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "Companion", "1.21.5"})
public final class Shimmy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object source;
    @NotNull
    private final Field field;
    @NotNull
    private final Class<?> clazz;

    private Shimmy(Object source, Field field) {
        this.source = source;
        this.field = field;
        Class<?> clazz = this.field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
        this.clazz = clazz;
    }

    @NotNull
    public final Object getSource() {
        return this.source;
    }

    @NotNull
    public final Field getField() {
        return this.field;
    }

    @NotNull
    public final Class<?> getClazz() {
        return this.clazz;
    }

    @Nullable
    public final Object get() {
        return this.field.get(this.source);
    }

    public final void set(@Nullable Object value) {
        this.field.set(this.source, value);
    }

    @NotNull
    public final JsonElement getJson() {
        JsonElement jsonElement = ConfigManager.Companion.getGson().toJsonTree(this.get());
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"toJsonTree(...)");
        return jsonElement;
    }

    public final void setJson(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.set(ConfigManager.Companion.getGson().fromJson(element, this.clazz));
    }

    public /* synthetic */ Shimmy(Object source, Field field, DefaultConstructorMarker $constructor_marker) {
        this(source, field);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/utils/json/Shimmy$Companion;", "", "<init>", "()V", "source", "", "fieldName", "shimmy", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "", "path", "Lat/hannibal2/skyhanni/utils/json/Shimmy;", "makeShimmy", "(Ljava/lang/Object;Ljava/util/List;)Lat/hannibal2/skyhanni/utils/json/Shimmy;", "1.21.5"})
    public static final class Companion {
        private Companion() {
        }

        private final Object shimmy(Object source, String fieldName) {
            Object object;
            if (source == null) {
                return null;
            }
            try {
                Field field = source.getClass().getDeclaredField(fieldName);
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"getDeclaredField(...)");
                Field declaredField = ReflectionUtils.INSTANCE.makeAccessible(field);
                object = declaredField.get(source);
            }
            catch (NoSuchFieldException e) {
                object = null;
            }
            return object;
        }

        @Nullable
        public final Shimmy makeShimmy(@Nullable Object source, @NotNull List<String> path) {
            Shimmy shimmy;
            Intrinsics.checkNotNullParameter(path, (String)"path");
            if (path.isEmpty()) {
                return null;
            }
            Object source2 = source;
            for (String part : CollectionsKt.dropLast(path, (int)1)) {
                source2 = this.shimmy(source2, part);
            }
            if (source2 == null) {
                return null;
            }
            String lastName = (String)CollectionsKt.last(path);
            try {
                Shimmy shimmy2;
                Field field = source2.getClass().getDeclaredField(lastName);
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"getDeclaredField(...)");
                Field field2 = ReflectionUtils.INSTANCE.makeAccessible(field);
                Shimmy shimmy3 = new Shimmy(source2, field2, null);
                if (Intrinsics.areEqual(shimmy3.getClazz(), Property.class)) {
                    Object object = this.shimmy(source2, lastName);
                    if (object == null) {
                        return shimmy3;
                    }
                    source2 = object;
                    shimmy2 = this.makeShimmy(source2, CollectionsKt.listOf((Object)"value"));
                    if (shimmy2 == null) {
                        shimmy2 = shimmy3;
                    }
                } else {
                    shimmy2 = shimmy3;
                }
                shimmy = shimmy2;
            }
            catch (NoSuchFieldException e) {
                shimmy = null;
            }
            return shimmy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

