/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.event.hoppity;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorColour;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorText;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.utils.OSUtils;
import com.google.gson.annotations.Expose;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0006\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityCallWarningConfig;", "", "<init>", "()V", "", "enabled", "Z", "getEnabled", "()Z", "setEnabled", "(Z)V", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/Property;", "", "hoppityCallSound", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/Property;", "getHoppityCallSound", "()Lio/github/notenoughupdates/moulconfig/observer/Property;", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "flashColor", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getFlashColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "setFlashColor", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;)V", "Ljava/lang/Runnable;", "sounds", "Ljava/lang/Runnable;", "getSounds", "()Ljava/lang/Runnable;", "ensureCoins", "getEnsureCoins", "setEnsureCoins", "", "coinThreshold", "I", "getCoinThreshold", "()I", "setCoinThreshold", "(I)V", "1.21.5"})
public final class HoppityCallWarningConfig {
    @Expose
    @ConfigOption(name="Hoppity Call Warning", desc="Warn when hoppity is calling you.")
    @ConfigEditorBoolean
    @FeatureToggle
    private boolean enabled;
    @Expose
    @ConfigOption(name="Warning Sound", desc="The sound that plays when hoppity calls.\n\u00a7eYou can use custom sounds, put it in the \u00a7bskyhanni/sounds \u00a7efolder in your resource pack.\n\u00a7eThen write \u00a7bskyhanni:yourfilename\n\u00a7cMust be a .ogg file")
    @ConfigEditorText
    @NotNull
    private final Property<String> hoppityCallSound;
    @Expose
    @ConfigOption(name="Flash Color", desc="Color of the screen when flashing")
    @ConfigEditorColour
    @NotNull
    private ChromaColour flashColor;
    @ConfigOption(name="Sounds", desc="Click to open the list of available sounds.")
    @ConfigEditorButton(buttonText="OPEN")
    @NotNull
    private final Runnable sounds;
    @Expose
    @ConfigOption(name="Ensure Coins Pre-Trade", desc="Block opening Hoppity's abiphone trade menu if you do not have enough coins in your purse.")
    @ConfigEditorBoolean
    private boolean ensureCoins;
    @Expose
    @ConfigOption(name="Coin Threshold", desc="The amount of coins you need to have in your purse to be able to open Hoppity's abiphone trade menu.")
    @ConfigEditorSlider(minValue=250000.0f, maxValue=5000000.0f, minStep=250000.0f)
    private int coinThreshold;

    public HoppityCallWarningConfig() {
        Property<String> property = Property.of("note.pling");
        Intrinsics.checkNotNullExpressionValue(property, (String)"of(...)");
        this.hoppityCallSound = property;
        this.flashColor = ChromaColour.Companion.fromStaticRGB(0, 238, 255, 127);
        this.sounds = OSUtils::openSoundsListInBrowser;
        this.coinThreshold = 5000000;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final Property<String> getHoppityCallSound() {
        return this.hoppityCallSound;
    }

    @NotNull
    public final ChromaColour getFlashColor() {
        return this.flashColor;
    }

    public final void setFlashColor(@NotNull ChromaColour chromaColour) {
        Intrinsics.checkNotNullParameter((Object)chromaColour, (String)"<set-?>");
        this.flashColor = chromaColour;
    }

    @NotNull
    public final Runnable getSounds() {
        return this.sounds;
    }

    public final boolean getEnsureCoins() {
        return this.ensureCoins;
    }

    public final void setEnsureCoins(boolean bl) {
        this.ensureCoins = bl;
    }

    public final int getCoinThreshold() {
        return this.coinThreshold;
    }

    public final void setCoinThreshold(int n) {
        this.coinThreshold = n;
    }
}

