/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.internal;

import at.hannibal2.skyhanni.deps.moulconfig.GuiTextures;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.internal.MCLogger;
import at.hannibal2.skyhanni.deps.moulconfig.internal.PropertyUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Warnings {
    public static boolean isDevEnv = IMinecraft.INSTANCE.isDevelopmentEnvironment();
    public static boolean shouldWarn = PropertyUtil.getBooleanWithFallback("moulconfig.warn", isDevEnv);
    public static boolean shouldCrash = shouldWarn && PropertyUtil.getBooleanWithFallback("moulconfig.warn.crash", isDevEnv);
    public static MCLogger logger = IMinecraft.INSTANCE.getLogger("MoulConfig");
    public static String basePackage = GuiTextures.class.getPackage().getName() + ".";
    public static String testPackage = basePackage + "test.";
    public static HashSet<Object> warnedObjects = new HashSet();

    public static void warnOnce(@NotNull String warningText, Object ... warningBucketEntries) {
        if (!shouldWarn) {
            return;
        }
        List<Object> warningBucket = Arrays.asList(warningBucketEntries);
        if (warnedObjects.contains(warningBucket)) {
            return;
        }
        warnedObjects.add(warningBucket);
        Warnings.warn0(warningText, 3);
    }

    public static void warnAt(@NotNull String warningText, @NotNull StackTraceElement firstOffender, @Nullable StackTraceElement modCall) {
        logger.warn("Warning: " + warningText + " at " + firstOffender + " called by " + modCall);
        if (shouldCrash) {
            throw new RuntimeException(warningText);
        }
    }

    private static void warn0(@NotNull String warningText, int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i2 = 0;
        StackTraceElement modCall = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (i2++ < depth || stackTraceElement.getClassName().startsWith("java.") || stackTraceElement.getClassName().startsWith("kotlin.") || stackTraceElement.getClassName().startsWith(basePackage) && !stackTraceElement.getClassName().startsWith(testPackage)) continue;
            modCall = stackTraceElement;
            break;
        }
        Warnings.warnAt(warningText, stackTrace[depth], modCall);
    }

    public static void warn(@NotNull String warningText, int depth) {
        if (shouldWarn) {
            Warnings.warn0(warningText, depth);
        }
    }

    public static void warn(@NotNull String warningText) {
        Warnings.warn(warningText, 4);
    }
}

