/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SeaCreatureInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SeaCreatureJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.fishing.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.fishing.SeaCreature;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0016\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR4\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001d0\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001b\u0010)\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001b\u0010,\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/fishing/SeaCreatureManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "message", "Lat/hannibal2/skyhanni/features/fishing/SeaCreature;", "getSeaCreatureFromMessage", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/fishing/SeaCreature;", "", "doubleHook", "Z", "", "seaCreatureMap", "Ljava/util/Map;", "", "allFishingMobs", "getAllFishingMobs", "()Ljava/util/Map;", "setAllFishingMobs", "(Ljava/util/Map;)V", "", "allVariants", "getAllVariants", "setAllVariants", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "doubleHookPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getDoubleHookPattern", "()Ljava/util/regex/Pattern;", "doubleHookPattern", "thunderBottleChargedPattern$delegate", "getThunderBottleChargedPattern", "thunderBottleChargedPattern", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nSeaCreatureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeaCreatureManager.kt\nat/hannibal2/skyhanni/features/fishing/SeaCreatureManager\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,96:1\n13#2,7:97\n21#2,6:114\n162#3,5:104\n167#3,4:110\n24#4:109\n*S KotlinDebug\n*F\n+ 1 SeaCreatureManager.kt\nat/hannibal2/skyhanni/features/fishing/SeaCreatureManager\n*L\n63#1:97,7\n63#1:114,6\n63#1:104,5\n63#1:110,4\n63#1:109\n*E\n"})
public final class SeaCreatureManager {
    @NotNull
    public static final SeaCreatureManager INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private static boolean doubleHook;
    @NotNull
    private static final Map<String, SeaCreature> seaCreatureMap;
    @NotNull
    private static Map<String, SeaCreature> allFishingMobs;
    @NotNull
    private static Map<String, ? extends List<String>> allVariants;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern doubleHookPattern$delegate;
    @NotNull
    private static final RepoPattern thunderBottleChargedPattern$delegate;

    private SeaCreatureManager() {
    }

    @NotNull
    public final Map<String, SeaCreature> getAllFishingMobs() {
        return allFishingMobs;
    }

    public final void setAllFishingMobs(@NotNull Map<String, SeaCreature> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        allFishingMobs = map;
    }

    @NotNull
    public final Map<String, List<String>> getAllVariants() {
        return allVariants;
    }

    public final void setAllVariants(@NotNull Map<String, ? extends List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        allVariants = map;
    }

    private final Pattern getDoubleHookPattern() {
        return (Pattern)doubleHookPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getThunderBottleChargedPattern() {
        return (Pattern)thunderBottleChargedPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (RegexUtils.INSTANCE.matches(this.getDoubleHookPattern(), event.getMessage())) {
            if (SkyHanniMod.feature.getFishing().getCompactDoubleHook()) {
                event.setBlockedReason("double_hook");
            }
            doubleHook = true;
        } else if (!doubleHook || !RegexUtils.INSTANCE.matches(this.getThunderBottleChargedPattern(), event.getMessage())) {
            SeaCreature seaCreature = this.getSeaCreatureFromMessage(event.getMessage());
            if (seaCreature != null) {
                new SeaCreatureFishEvent(seaCreature, event, doubleHook).post();
            }
            doubleHook = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        void constant$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        seaCreatureMap.clear();
        allFishingMobs = MapsKt.emptyMap();
        int counter = 0;
        String string = "SeaCreatures";
        Type type$iv = SeaCreatureJson.Companion.getTYPE();
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                Object object4;
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, (String)constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + (String)constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                if (type$iv == null) {
                    Gson $this$fromJson$iv$iv$iv = gson$iv;
                    boolean $i$f$fromJson = false;
                    Object object5 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(SeaCreatureJson.class)))));
                    object4 = object5;
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"fromJson(...)");
                } else {
                    Object object6 = gson$iv.fromJson(json$iv$iv, type$iv);
                    object4 = object6;
                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"fromJson(...)");
                }
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + (String)constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant((String)constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant((String)constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + (String)constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        Map data = (Map)object;
        Map allFishingMobs = new LinkedHashMap();
        Map variants = new LinkedHashMap();
        for (Map.Entry entry : data.entrySet()) {
            String variantName = (String)entry.getKey();
            SeaCreatureJson variant = (SeaCreatureJson)entry.getValue();
            String chatColor = variant.getChatColor();
            List variantFishes = new ArrayList();
            variants.put(variantName, variantFishes);
            for (Map.Entry<String, SeaCreatureInfo> entry2 : variant.getSeaCreatures().entrySet()) {
                String name2 = entry2.getKey();
                SeaCreatureInfo seaCreature = entry2.getValue();
                String chatMessage = seaCreature.getChatMessage();
                int fishingExperience = seaCreature.getFishingExperience();
                LorenzRarity rarity = seaCreature.getRarity();
                boolean rare = seaCreature.getRare();
                SeaCreature creature = new SeaCreature(name2, fishingExperience, chatColor, rare, rarity);
                seaCreatureMap.put(chatMessage, creature);
                List list = seaCreature.getAlternateMessages();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                for (String alternateMessage : list) {
                    seaCreatureMap.put(alternateMessage, creature);
                }
                allFishingMobs.put(name2, creature);
                variantFishes.add(name2);
                ++counter;
            }
        }
        SeaCreatureManager.allFishingMobs = allFishingMobs;
        allVariants = variants;
    }

    private final SeaCreature getSeaCreatureFromMessage(String message) {
        return seaCreatureMap.getOrDefault(message, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SeaCreatureManager.class, "doubleHookPattern", "getDoubleHookPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SeaCreatureManager.class, "thunderBottleChargedPattern", "getThunderBottleChargedPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SeaCreatureManager();
        seaCreatureMap = new LinkedHashMap();
        allFishingMobs = MapsKt.emptyMap();
        allVariants = MapsKt.emptyMap();
        patternGroup = RepoPattern.Companion.group("fishing.seacreature");
        doubleHookPattern$delegate = patternGroup.pattern("doublehook", "\u00a7eIt's a \u00a7r\u00a7aDouble Hook\u00a7r\u00a7e!(?: Woot woot!)?");
        thunderBottleChargedPattern$delegate = patternGroup.pattern("thundercharged", "\u00a7e> Your bottle of thunder has fully charged!");
    }
}

