/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.glacitemineshaft;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.glacite.MineshaftDetectionConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.PartyApi;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010%\u001a\u0004\u0018\u00010\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;", "type", "", "getSinceMineshaftType", "(Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;)I", "value", "", "setSinceMineshaftType", "(Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;I)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "getTimeSinceMineshaftType-1cd6UlU", "(Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;)J", "getTimeSinceMineshaftType", "time", "setTimeSinceMineshaftType-qFiuR7c", "(Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;J)V", "setTimeSinceMineshaftType", "Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;", "event", "onWorldChange", "(Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "handleShaftData", "(Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;)V", "Lat/hannibal2/skyhanni/config/features/mining/glacite/MineshaftDetectionConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/glacite/MineshaftDetectionConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningStorage$MineshaftStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningStorage$MineshaftStorage;", "profileStorage", "", "found", "Z", "MineshaftTypes", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nMineshaftDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MineshaftDetection.kt\nat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n295#2:142\n1761#2,3:143\n296#2:146\n295#2,2:147\n*S KotlinDebug\n*F\n+ 1 MineshaftDetection.kt\nat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection\n*L\n54#1:142\n54#1:143,3\n54#1:146\n61#1:147,2\n*E\n"})
public final class MineshaftDetection {
    @NotNull
    public static final MineshaftDetection INSTANCE = new MineshaftDetection();
    private static boolean found;

    private MineshaftDetection() {
    }

    private final MineshaftDetectionConfig getConfig() {
        return SkyHanniMod.feature.getMining().getGlaciteMineshaft().getMineshaftDetectionConfig();
    }

    private final ProfileSpecificStorage.MiningStorage.MineshaftStorage getProfileStorage() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).getMining()) != null ? ((ProfileSpecificStorage.MiningStorage)object).getMineshaft() : null;
    }

    private final int getSinceMineshaftType(MineshaftTypes type2) {
        Object object = this.getProfileStorage();
        return object != null && (object = ((ProfileSpecificStorage.MiningStorage.MineshaftStorage)object).getMineshaftsEnteredSince()) != null && (object = (Integer)object.get((Object)type2)) != null ? (Integer)object : 0;
    }

    private final void setSinceMineshaftType(MineshaftTypes type2, int value) {
        block0: {
            Map<MineshaftTypes, Integer> map;
            ProfileSpecificStorage.MiningStorage.MineshaftStorage mineshaftStorage = this.getProfileStorage();
            if (mineshaftStorage == null || (map = mineshaftStorage.getMineshaftsEnteredSince()) == null) break block0;
            Integer n = value;
            map.put(type2, n);
        }
    }

    private final long getTimeSinceMineshaftType-1cd6UlU(MineshaftTypes type2) {
        Object object = this.getProfileStorage();
        return object != null && (object = ((ProfileSpecificStorage.MiningStorage.MineshaftStorage)object).getLastMineshaftTime()) != null && (object = (SimpleTimeMark)object.get((Object)type2)) != null ? ((SimpleTimeMark)object).unbox-impl() : SimpleTimeMark.Companion.farPast();
    }

    private final void setTimeSinceMineshaftType-qFiuR7c(MineshaftTypes type2, long time) {
        block0: {
            Map<MineshaftTypes, SimpleTimeMark> map;
            ProfileSpecificStorage.MiningStorage.MineshaftStorage mineshaftStorage = this.getProfileStorage();
            if (mineshaftStorage == null || (map = mineshaftStorage.getLastMineshaftTime()) == null) break block0;
            SimpleTimeMark simpleTimeMark = SimpleTimeMark.box-impl(time);
            map.put(type2, simpleTimeMark);
        }
    }

    @HandleEvent
    public final void onWorldChange(@NotNull WorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getConfig().getMineshaftDetection()) {
            return;
        }
        found = false;
    }

    @HandleEvent(onlyOnIsland=IslandType.MINESHAFT)
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Object v2;
        String areaName;
        block13: {
            Object v1;
            String[] $this$firstOrNull$iv;
            block12: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.getConfig().getMineshaftDetection()) {
                    return;
                }
                if (found) {
                    return;
                }
                Iterable iterable = ScoreboardData.INSTANCE.getSidebarLinesFormatted();
                boolean $i$f$firstOrNull = false;
                for (Object t : $this$firstOrNull$iv) {
                    boolean bl;
                    block11: {
                        String line = (String)t;
                        boolean bl2 = false;
                        Iterable $this$any$iv = (Iterable)MineshaftTypes.getEntries();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                MineshaftTypes it = (MineshaftTypes)((Object)element$iv2);
                                boolean bl3 = false;
                                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it.name(), (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v1 = t;
                    break block12;
                }
                v1 = null;
            }
            String string = v1;
            if (string == null || ($this$firstOrNull$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null)) == null) {
                return;
            }
            String[] matchingLine = $this$firstOrNull$iv;
            $this$firstOrNull$iv = new String[]{" "};
            areaName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)matchingLine), (String[])$this$firstOrNull$iv, (boolean)false, (int)0, (int)6, null));
            ChatUtils.debug$default(ChatUtils.INSTANCE, "In area: " + areaName, false, 2, null);
            Iterable $this$firstOrNull$iv2 = (Iterable)MineshaftTypes.getEntries();
            boolean bl = false;
            for (Object element$iv : $this$firstOrNull$iv2) {
                MineshaftTypes it = (MineshaftTypes)((Object)element$iv);
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)areaName, (CharSequence)it.name(), (boolean)false, (int)2, null)) continue;
                v2 = element$iv;
                break block13;
            }
            v2 = null;
        }
        MineshaftTypes mineshaftTypes = v2;
        if (mineshaftTypes == null) {
            return;
        }
        MineshaftTypes type2 = mineshaftTypes;
        found = true;
        ChatUtils.debug$default(ChatUtils.INSTANCE, "Found a " + type2.name() + " mineshaft! [" + areaName + "]", false, 2, null);
        int sinceThis = this.getSinceMineshaftType(type2);
        long timeSinceThis = this.getTimeSinceMineshaftType-1cd6UlU(type2);
        String formattedTime = !SimpleTimeMark.isFarPast-impl(timeSinceThis) ? TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, SimpleTimeMark.passedSince-UwyO8pc(timeSinceThis), null, false, false, 0, false, false, 63, null) : "Unknown (no data yet)";
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You entered a " + type2.getDisplayName() + " mineshaft!", false, null, false, false, null, 62, null);
        if (this.getConfig().getMineshaftsToTrack().contains((Object)type2)) {
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, type2.getDisplayName(), null, 0L, null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16382, null);
            String message = "\u00a7aIt took \u00a7e" + formattedTime + " \u00a7aand \u00a7e" + sinceThis + " " + StringUtils.INSTANCE.pluralize("\u00a7amineshaft", sinceThis) + " entered to get a \u00a7e" + type2.getDisplayName() + " \u00a7amineshaft.";
            ChatUtils.chat$default(ChatUtils.INSTANCE, message, false, null, false, false, null, 62, null);
        }
        this.handleShaftData(type2);
        if (this.getConfig().getSendTypeToPartyChat() && PartyApi.INSTANCE.isInParty()) {
            StringBuilder partyChatBuilder = new StringBuilder();
            String formattedMessage = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.getConfig().getPartyChatFormat(), (String)"{type}", (String)type2.getDisplayName(), (boolean)false, (int)4, null), (String)"{amountSinceThis}", (String)String.valueOf(sinceThis), (boolean)false, (int)4, null), (String)"{timeSinceThis}", (String)formattedTime, (boolean)false, (int)4, null);
            partyChatBuilder.append(formattedMessage);
            String string = partyChatBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            HypixelCommands.partyChat$default(HypixelCommands.INSTANCE, StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null), false, 2, null);
        }
    }

    private final void handleShaftData(MineshaftTypes type2) {
        this.setSinceMineshaftType(type2, 0);
        this.setTimeSinceMineshaftType-qFiuR7c(type2, SimpleTimeMark.Companion.now-uFjCsEo());
        for (MineshaftTypes otherTypes : MineshaftTypes.getEntries()) {
            if (otherTypes == type2) continue;
            this.setSinceMineshaftType(otherTypes, this.getSinceMineshaftType(otherTypes) + 1);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b#\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\rj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/mining/glacitemineshaft/MineshaftDetection$MineshaftTypes;", "", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "color", "", "rawName", "<init>", "(Ljava/lang/String;ILat/hannibal2/skyhanni/utils/LorenzColor;Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "getColor", "()Lat/hannibal2/skyhanni/utils/LorenzColor;", "Ljava/lang/String;", "getRawName", "()Ljava/lang/String;", "displayName", "getDisplayName", "TOPA1", "SAPP1", "AMET1", "AMBE1", "JADE1", "TITA1", "UMBE1", "TUNG1", "FAIR1", "RUBY1", "RUBY2", "ONYX1", "ONYX2", "AQUA1", "AQUA2", "CITR1", "CITR2", "PERI1", "PERI2", "JASP1", "JASP2", "OPAL1", "OPAL2", "1.21.5"})
    public static final class MineshaftTypes
    extends Enum<MineshaftTypes> {
        @NotNull
        private final LorenzColor color;
        @NotNull
        private final String rawName;
        @NotNull
        private final String displayName;
        public static final /* enum */ MineshaftTypes TOPA1 = new MineshaftTypes(LorenzColor.YELLOW, "Topaz");
        public static final /* enum */ MineshaftTypes SAPP1 = new MineshaftTypes(LorenzColor.BLUE, "Sapphire");
        public static final /* enum */ MineshaftTypes AMET1 = new MineshaftTypes(LorenzColor.DARK_PURPLE, "Amethyst");
        public static final /* enum */ MineshaftTypes AMBE1 = new MineshaftTypes(LorenzColor.GOLD, "Amber");
        public static final /* enum */ MineshaftTypes JADE1 = new MineshaftTypes(LorenzColor.GREEN, "Jade");
        public static final /* enum */ MineshaftTypes TITA1 = new MineshaftTypes(LorenzColor.GRAY, "Titanium");
        public static final /* enum */ MineshaftTypes UMBE1 = new MineshaftTypes(LorenzColor.GOLD, "Umber");
        public static final /* enum */ MineshaftTypes TUNG1 = new MineshaftTypes(LorenzColor.DARK_GRAY, "Tungsten");
        public static final /* enum */ MineshaftTypes FAIR1 = new MineshaftTypes(LorenzColor.WHITE, "Vanguard");
        public static final /* enum */ MineshaftTypes RUBY1 = new MineshaftTypes(LorenzColor.RED, "Ruby");
        public static final /* enum */ MineshaftTypes RUBY2 = new MineshaftTypes(LorenzColor.RED, "Ruby Crystal");
        public static final /* enum */ MineshaftTypes ONYX1 = new MineshaftTypes(LorenzColor.BLACK, "Onyx");
        public static final /* enum */ MineshaftTypes ONYX2 = new MineshaftTypes(LorenzColor.BLACK, "Onyx Crystal");
        public static final /* enum */ MineshaftTypes AQUA1 = new MineshaftTypes(LorenzColor.DARK_BLUE, "Aquamarine");
        public static final /* enum */ MineshaftTypes AQUA2 = new MineshaftTypes(LorenzColor.DARK_BLUE, "Aquamarine Crystal");
        public static final /* enum */ MineshaftTypes CITR1 = new MineshaftTypes(LorenzColor.YELLOW, "Citrine");
        public static final /* enum */ MineshaftTypes CITR2 = new MineshaftTypes(LorenzColor.YELLOW, "Citrine Crystal");
        public static final /* enum */ MineshaftTypes PERI1 = new MineshaftTypes(LorenzColor.DARK_GREEN, "Peridot");
        public static final /* enum */ MineshaftTypes PERI2 = new MineshaftTypes(LorenzColor.DARK_GREEN, "Peridot Crystal");
        public static final /* enum */ MineshaftTypes JASP1 = new MineshaftTypes(LorenzColor.LIGHT_PURPLE, "Jasper");
        public static final /* enum */ MineshaftTypes JASP2 = new MineshaftTypes(LorenzColor.LIGHT_PURPLE, "Jasper Crystal");
        public static final /* enum */ MineshaftTypes OPAL1 = new MineshaftTypes(LorenzColor.WHITE, "Opal");
        public static final /* enum */ MineshaftTypes OPAL2 = new MineshaftTypes(LorenzColor.WHITE, "Opal Crystal");
        private static final /* synthetic */ MineshaftTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MineshaftTypes(LorenzColor color, String rawName) {
            this.color = color;
            this.rawName = rawName;
            this.displayName = this.color.getChatColor() + this.rawName;
        }

        @NotNull
        public final LorenzColor getColor() {
            return this.color;
        }

        @NotNull
        public final String getRawName() {
            return this.rawName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static MineshaftTypes[] values() {
            return (MineshaftTypes[])$VALUES.clone();
        }

        public static MineshaftTypes valueOf(String value) {
            return Enum.valueOf(MineshaftTypes.class, value);
        }

        @NotNull
        public static EnumEntries<MineshaftTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mineshaftTypesArray = new MineshaftTypes[]{MineshaftTypes.TOPA1, MineshaftTypes.SAPP1, MineshaftTypes.AMET1, MineshaftTypes.AMBE1, MineshaftTypes.JADE1, MineshaftTypes.TITA1, MineshaftTypes.UMBE1, MineshaftTypes.TUNG1, MineshaftTypes.FAIR1, MineshaftTypes.RUBY1, MineshaftTypes.RUBY2, MineshaftTypes.ONYX1, MineshaftTypes.ONYX2, MineshaftTypes.AQUA1, MineshaftTypes.AQUA2, MineshaftTypes.CITR1, MineshaftTypes.CITR2, MineshaftTypes.PERI1, MineshaftTypes.PERI2, MineshaftTypes.JASP1, MineshaftTypes.JASP2, MineshaftTypes.OPAL1, MineshaftTypes.OPAL2};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

