/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.update;

import at.hannibal2.skyhanni.deps.libautoupdate.GithubReleaseUpdateData;
import at.hannibal2.skyhanni.deps.libautoupdate.GithubReleaseUpdateSource;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateData;
import at.hannibal2.skyhanni.utils.VersionConstants;
import at.hannibal2.skyhanni.utils.system.ModVersion;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u000b\u001a\u00020\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u00020\u0014*\u00020\u00102\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lat/hannibal2/skyhanni/features/misc/update/CustomGithubReleaseUpdateSource;", "Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource;", "", "owner", "repository", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "", "Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource$GithubRelease;", "validReleases", "Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateData;", "findLatestRelease", "(Ljava/lang/Iterable;)Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateData;", "release", "findAsset", "(Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource$GithubRelease;)Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateData;", "Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource$GithubRelease$Download;", "", "filterAsset", "(Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource$GithubRelease$Download;)Z", "Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateData;", "createReleaseData", "(Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource$GithubRelease$Download;Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateSource$GithubRelease;)Lat/hannibal2/skyhanni/deps/libautoupdate/GithubReleaseUpdateData;", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nCustomGithubReleaseUpdateSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomGithubReleaseUpdateSource.kt\nat/hannibal2/skyhanni/features/misc/update/CustomGithubReleaseUpdateSource\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1431#2,14:51\n1#3:65\n*S KotlinDebug\n*F\n+ 1 CustomGithubReleaseUpdateSource.kt\nat/hannibal2/skyhanni/features/misc/update/CustomGithubReleaseUpdateSource\n*L\n16#1:51,14\n*E\n"})
public final class CustomGithubReleaseUpdateSource
extends GithubReleaseUpdateSource {
    public CustomGithubReleaseUpdateSource(@NotNull String owner, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        super(owner, repository);
    }

    @NotNull
    protected UpdateData findLatestRelease(@NotNull Iterable<? extends GithubReleaseUpdateSource.GithubRelease> validReleases) {
        Object e;
        Intrinsics.checkNotNullParameter(validReleases, (String)"validReleases");
        Sequence $this$maxBy$iv = CollectionsKt.asSequence(validReleases);
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            e = maxElem$iv;
        } else {
            GithubReleaseUpdateSource.GithubRelease it = (GithubReleaseUpdateSource.GithubRelease)maxElem$iv;
            boolean bl = false;
            String string = it.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
            Comparable maxValue$iv = ModVersion.Companion.fromString(string);
            do {
                Object e$iv = iterator$iv.next();
                GithubReleaseUpdateSource.GithubRelease it2 = (GithubReleaseUpdateSource.GithubRelease)e$iv;
                $i$a$-maxByOrThrow-CustomGithubReleaseUpdateSource$findLatestRelease$1 = false;
                String string2 = it2.getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTagName(...)");
                Comparable v$iv = ModVersion.Companion.fromString(string2);
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            e = maxElem$iv;
        }
        GithubReleaseUpdateSource.GithubRelease it = (GithubReleaseUpdateSource.GithubRelease)e;
        boolean bl = false;
        UpdateData updateData2 = this.findAsset(it);
        if (updateData2 == null) {
            throw new IllegalStateException("No valid release found");
        }
        return updateData2;
    }

    @Override
    @Nullable
    protected UpdateData findAsset(@Nullable GithubReleaseUpdateSource.GithubRelease release) {
        if (release == null) {
            return null;
        }
        return release.getAssets().stream().filter(arg_0 -> CustomGithubReleaseUpdateSource.findAsset$lambda$3(arg_0 -> CustomGithubReleaseUpdateSource.findAsset$lambda$2(this, arg_0), arg_0)).map(arg_0 -> CustomGithubReleaseUpdateSource.findAsset$lambda$5(arg_0 -> CustomGithubReleaseUpdateSource.findAsset$lambda$4(this, release, arg_0), arg_0)).findFirst().orElse(null);
    }

    private final boolean filterAsset(GithubReleaseUpdateSource.GithubRelease.Download $this$filterAsset) {
        if ($this$filterAsset.getName() == null) {
            return false;
        }
        if ($this$filterAsset.getBrowserDownloadUrl() == null) {
            return false;
        }
        String string = $this$filterAsset.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            return false;
        }
        String string2 = $this$filterAsset.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)VersionConstants.INSTANCE.getMC_VERSION(), (boolean)false, (int)2, null);
    }

    private final GithubReleaseUpdateData createReleaseData(GithubReleaseUpdateSource.GithubRelease.Download $this$createReleaseData, GithubReleaseUpdateSource.GithubRelease release) {
        return new GithubReleaseUpdateData(release.getName() == null ? release.getTagName() : release.getName(), (JsonElement)new JsonPrimitive(release.getTagName()), null, $this$createReleaseData.getBrowserDownloadUrl(), release.getBody(), release.getTargetCommitish(), release.getCreated_at(), release.getPublishedAt(), release.getHtmlUrl());
    }

    private static final boolean findAsset$lambda$2(CustomGithubReleaseUpdateSource this$0, GithubReleaseUpdateSource.GithubRelease.Download it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return this$0.filterAsset(it);
    }

    private static final boolean findAsset$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final GithubReleaseUpdateData findAsset$lambda$4(CustomGithubReleaseUpdateSource this$0, GithubReleaseUpdateSource.GithubRelease $release, GithubReleaseUpdateSource.GithubRelease.Download it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return this$0.createReleaseData(it, $release);
    }

    private static final GithubReleaseUpdateData findAsset$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GithubReleaseUpdateData)$tmp0.invoke(p0);
    }
}

