/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.events.chat.TabCompletionEvent;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommandDispatcher.class}, remap=false)
public class MixinCommandDispatcher<S> {
    @Inject(method={"getCompletionSuggestions(Lcom/mojang/brigadier/ParseResults;I)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="INVOKE", target="Ljava/lang/String;toLowerCase(Ljava/util/Locale;)Ljava/lang/String;")}, cancellable=true)
    public void getCompletionSuggestions(ParseResults<S> parse2, int cursor, CallbackInfoReturnable<CompletableFuture<Suggestions>> cir, @Local(ordinal=1) int start2, @Local(ordinal=0) String fullInput, @Local(ordinal=1) String beforeCursor) {
        if (!beforeCursor.contains(" ")) {
            return;
        }
        SuggestionsBuilder suggestionsBuilder = this.buildFromEvent(start2, fullInput, beforeCursor, new ArrayList<String>());
        if (suggestionsBuilder == null) {
            return;
        }
        cir.setReturnValue((Object)suggestionsBuilder.buildFuture());
    }

    @ModifyReturnValue(method={"getCompletionSuggestions(Lcom/mojang/brigadier/ParseResults;I)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    public CompletableFuture<Suggestions> getCompletionSuggestionsWIthExisting(CompletableFuture<Suggestions> original, @Local(ordinal=1) int start2, @Local(ordinal=0) String fullInput, @Local(ordinal=1) String beforeCursor) {
        if (beforeCursor.contains(" ")) {
            return original;
        }
        return original.thenApply(suggestions -> {
            ArrayList<String> suggestionList = new ArrayList<String>(suggestions.getList().stream().map(Suggestion::getText).toList());
            SuggestionsBuilder newSuggestions = this.buildFromEvent(start2, fullInput, beforeCursor, suggestionList);
            if (newSuggestions == null) {
                return suggestions;
            }
            return newSuggestions.build();
        });
    }

    @Unique
    private SuggestionsBuilder buildFromEvent(int start2, String fullInput, String beforeCursor, ArrayList<String> existing) {
        TabCompletionEvent tabCompletionEvent = new TabCompletionEvent(fullInput, beforeCursor, existing);
        tabCompletionEvent.post();
        String[] additional = tabCompletionEvent.intoSuggestionArray();
        if (additional == null) {
            return null;
        }
        SuggestionsBuilder suggestionsBuilder = new SuggestionsBuilder(beforeCursor, start2);
        for (String s : additional) {
            suggestionsBuilder.suggest(s);
        }
        return suggestionsBuilder;
    }
}

