/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.GardenLevelConfig;
import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.ItemCompatKt;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u0017*\u00020\fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R$\u00100\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010$\"\u0004\b.\u0010/R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001b\u00109\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u001b\u0010<\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u00106\u001a\u0004\b;\u00108R\u001b\u0010?\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u00106\u001a\u0004\b>\u00108R\u001b\u0010B\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u00106\u001a\u0004\bA\u00108R\u001b\u0010E\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u00106\u001a\u0004\bD\u00108R\u001b\u0010H\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u00106\u001a\u0004\bG\u00108R\u0016\u0010I\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010J\u00a8\u0006K"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenLevelDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "", "moreExp", "addExp", "(I)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "update", "", "drawDisplay", "()Ljava/lang/String;", "toRomanIfNecessary", "(I)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/GardenLevelConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/GardenLevelConfig;", "config", "value", "getUseRomanNumerals", "setUseRomanNumerals", "(Z)V", "useRomanNumerals", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "expToNextLevelPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getExpToNextLevelPattern", "()Ljava/util/regex/Pattern;", "expToNextLevelPattern", "gardenItemNamePattern$delegate", "getGardenItemNamePattern", "gardenItemNamePattern", "overflowPattern$delegate", "getOverflowPattern", "overflowPattern", "gardenLevelPattern$delegate", "getGardenLevelPattern", "gardenLevelPattern", "gardenMaxLevelPattern$delegate", "getGardenMaxLevelPattern", "gardenMaxLevelPattern", "visitorRewardPattern$delegate", "getVisitorRewardPattern", "visitorRewardPattern", "display", "Ljava/lang/String;", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nGardenLevelDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenLevelDisplay.kt\nat/hannibal2/skyhanni/features/garden/GardenLevelDisplay\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n8#2:249\n8#2:251\n8#2:253\n8#2:255\n8#2:257\n1#3:250\n1#3:252\n1#3:254\n1#3:256\n1#3:258\n*S KotlinDebug\n*F\n+ 1 GardenLevelDisplay.kt\nat/hannibal2/skyhanni/features/garden/GardenLevelDisplay\n*L\n103#1:249\n137#1:251\n144#1:253\n148#1:255\n151#1:257\n103#1:250\n137#1:252\n144#1:254\n148#1:256\n151#1:258\n*E\n"})
public final class GardenLevelDisplay {
    @NotNull
    public static final GardenLevelDisplay INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern expToNextLevelPattern$delegate;
    @NotNull
    private static final RepoPattern gardenItemNamePattern$delegate;
    @NotNull
    private static final RepoPattern overflowPattern$delegate;
    @NotNull
    private static final RepoPattern gardenLevelPattern$delegate;
    @NotNull
    private static final RepoPattern gardenMaxLevelPattern$delegate;
    @NotNull
    private static final RepoPattern visitorRewardPattern$delegate;
    @NotNull
    private static String display;

    private GardenLevelDisplay() {
    }

    private final GardenLevelConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getGardenLevels();
    }

    private final boolean getUseRomanNumerals() {
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        return playerSpecificStorage != null ? playerSpecificStorage.getUseRomanNumerals() : true;
    }

    private final void setUseRomanNumerals(boolean value) {
        block0: {
            PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
            if (playerSpecificStorage == null) break block0;
            playerSpecificStorage.setUseRomanNumerals(value);
        }
    }

    private final Pattern getExpToNextLevelPattern() {
        return (Pattern)expToNextLevelPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getGardenItemNamePattern() {
        return (Pattern)gardenItemNamePattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final Pattern getOverflowPattern() {
        return (Pattern)overflowPattern$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final Pattern getGardenLevelPattern() {
        return (Pattern)gardenLevelPattern$delegate.getValue(this, $$delegatedProperties[3]);
    }

    private final Pattern getGardenMaxLevelPattern() {
        return (Pattern)gardenMaxLevelPattern$delegate.getValue(this, $$delegatedProperties[4]);
    }

    private final Pattern getVisitorRewardPattern() {
        return (Pattern)visitorRewardPattern$delegate.getValue(this, $$delegatedProperties[5]);
    }

    @HandleEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getVisitorRewardPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String string = $this$onChat_u24lambda_u240.group("exp");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            INSTANCE.addExp(Integer.parseInt(string));
        }
    }

    private final void addExp(int moreExp) {
        Long l = GardenApi.INSTANCE.getGardenExp();
        if (l == null) {
            return;
        }
        long gardenExp = l;
        int oldLevel = GardenApi.getGardenLevel$default(GardenApi.INSTANCE, false, 1, null);
        GardenApi.INSTANCE.setGardenExp(gardenExp + (long)moreExp);
        this.update();
        if (!this.getConfig().getOverflowChat()) {
            return;
        }
        int newLevel = GardenApi.getGardenLevel$default(GardenApi.INSTANCE, false, 1, null);
        if (newLevel != oldLevel + 1 || newLevel <= 15) {
            return;
        }
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)50, (DurationUnit)DurationUnit.MILLISECONDS), (Function0<Unit>)((Function0)() -> GardenLevelDisplay.addExp$lambda$2(oldLevel, newLevel)));
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event) {
        Unit unit;
        Iterator<String> $this$matchMatcher$iv;
        class_1799 class_17992;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getInventoryName();
        if (Intrinsics.areEqual((Object)string, (Object)"Desk")) {
            class_17992 = event.getInventoryItems().get(4);
            if (class_17992 == null) {
                return;
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"SkyBlock Menu")) {
            class_17992 = event.getInventoryItems().get(10);
            if (class_17992 == null) {
                return;
            }
        } else {
            return;
        }
        class_1799 item2 = class_17992;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getGardenItemNamePattern();
        String text$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, TextCompatKt.formattedTextCompatLeadingWhiteLessResets(item2.method_7964()), false, 1, null);
        boolean $i$f$matchMatcher2 = false;
        Matcher it$iv = ((Pattern)((Object)$this$matchMatcher$iv)).matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onInventoryFullyOpened_u24lambda_u243 = it$iv;
            boolean bl2 = false;
            String level = RegexUtils.INSTANCE.groupOrNull($this$onInventoryFullyOpened_u24lambda_u243, "currentLevel");
            if (level != null) {
                INSTANCE.setUseRomanNumerals(StringUtils.INSTANCE.isRoman(level));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            return;
        }
        long nextLevelExp = 0L;
        int currentLevel = 0;
        for (String line : ItemUtils.INSTANCE.getLore(item2)) {
            RegexUtils $i$f$matchMatcher2 = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv2 = this.getGardenLevelPattern();
            boolean $i$f$matchMatcher3 = false;
            Matcher it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (it$iv2.matches()) {
                Intrinsics.checkNotNull((Object)it$iv2);
                Matcher $this$onInventoryFullyOpened_u24lambda_u244 = it$iv2;
                boolean bl3 = false;
                String string2 = $this$onInventoryFullyOpened_u24lambda_u244.group("currentLevel");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                currentLevel = NumberUtil.INSTANCE.romanToDecimalIfNecessary(string2) - 1;
            }
            if (Intrinsics.areEqual((Object)line, (Object)"\u00a77\u00a78Max level reached!")) {
                currentLevel = 15;
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv2 = this.getExpToNextLevelPattern();
            $i$f$matchMatcher3 = false;
            it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (it$iv2.matches()) {
                Intrinsics.checkNotNull((Object)it$iv2);
                Matcher $this$onInventoryFullyOpened_u24lambda_u245 = it$iv2;
                boolean bl4 = false;
                String string3 = $this$onInventoryFullyOpened_u24lambda_u245.group("nextLevelExp");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                nextLevelExp = NumberUtil.INSTANCE.formatLong(string3);
            }
            this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv2 = this.getOverflowPattern();
            $i$f$matchMatcher3 = false;
            it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (!it$iv2.matches()) continue;
            Intrinsics.checkNotNull((Object)it$iv2);
            Matcher $this$onInventoryFullyOpened_u24lambda_u246 = it$iv2;
            boolean bl5 = false;
            String string4 = $this$onInventoryFullyOpened_u24lambda_u246.group("overflow");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
            long overflow = NumberUtil.INSTANCE.formatLong(string4);
            GardenApi.INSTANCE.setGardenExp(overflow);
            INSTANCE.update();
            return;
        }
        int expForLevel = (int)GardenApi.INSTANCE.getExpForLevel(currentLevel);
        GardenApi.INSTANCE.setGardenExp((long)expForLevel + nextLevelExp);
        this.update();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onToolTip(@NotNull ToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!((Boolean)this.getConfig().getOverflow().get()).booleanValue()) {
            return;
        }
        int slotIndex = event.getSlot().method_34266();
        String name2 = InventoryUtils.INSTANCE.openInventoryName();
        if (!(Intrinsics.areEqual((Object)name2, (Object)"Desk") && slotIndex == 4 || Intrinsics.areEqual((Object)name2, (Object)"SkyBlock Menu") && slotIndex == 10)) {
            return;
        }
        Long l = GardenApi.INSTANCE.getGardenExp();
        if (l == null) {
            return;
        }
        long gardenExp = l;
        int currentLevel = GardenApi.getGardenLevel$default(GardenApi.INSTANCE, false, 1, null);
        if (currentLevel < 15) {
            return;
        }
        int needForLevel = (int)GardenApi.INSTANCE.getExpForLevel(currentLevel);
        double overflow = gardenExp - (long)needForLevel;
        int overflowTotal = (int)(gardenExp - GardenApi.INSTANCE.getExpForLevel(15));
        int needForNextLevel = (int)GardenApi.INSTANCE.getExpForLevel(currentLevel + 1);
        int needForOnlyNextLvl = needForNextLevel - needForLevel;
        ListIterator<String> iterator2 = event.getToolTip().listIterator();
        if (slotIndex == 4 && currentLevel > 15) {
            ItemCompatKt.setCustomItemName(event.getItemStack(), "\u00a7aGarden Level " + this.toRomanIfNecessary(currentLevel));
        }
        boolean next = false;
        ListIterator<String> listIterator = iterator2;
        while (((Iterator)listIterator).hasNext()) {
            String line = listIterator.next();
            if (RegexUtils.INSTANCE.matches(this.getGardenMaxLevelPattern(), line)) {
                iterator2.set("\u00a77Progress to Level " + this.toRomanIfNecessary(currentLevel + 1));
                next = true;
                continue;
            }
            if (!next || !StringsKt.contains$default((CharSequence)line, (CharSequence)"                    ", (boolean)false, (int)2, null)) continue;
            double progress = overflow / (double)needForOnlyNextLvl;
            Object progressBar2 = StringUtils.INSTANCE.progressBar(progress, 20);
            iterator2.set(progressBar2 + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(overflow) + "\u00a76/\u00a7e" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, needForOnlyNextLvl, false, 1, null));
            iterator2.add("");
            iterator2.add("\u00a7b\u00a7lOVERFLOW XP:");
            iterator2.add("\u00a77\u25b8 " + NumberUtil.INSTANCE.addSeparators(overflowTotal));
            return;
        }
    }

    private final void update() {
        display = this.drawDisplay();
    }

    private final String drawDisplay() {
        String string;
        Long l = GardenApi.INSTANCE.getGardenExp();
        if (l == null) {
            return "\u00a7aGarden Level ? \u00a7cOpen the desk!";
        }
        long gardenExp = l;
        Object t = this.getConfig().getOverflow().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        int currentLevel = GardenApi.INSTANCE.getGardenLevel((Boolean)t);
        boolean isMax = (Boolean)this.getConfig().getOverflow().get() == false && currentLevel == 15;
        int needForLevel = (int)GardenApi.INSTANCE.getExpForLevel(currentLevel);
        long overflow = gardenExp - (long)needForLevel;
        if (isMax) {
            string = "\u00a77(\u00a7e" + NumberUtil.INSTANCE.addSeparators(overflow) + "\u00a77)";
        } else {
            int needForNextLevel = (int)GardenApi.INSTANCE.getExpForLevel(currentLevel + 1);
            int needForOnlyNextLevel = needForNextLevel - needForLevel;
            string = "\u00a77(\u00a7e" + NumberUtil.INSTANCE.addSeparators(overflow) + "\u00a77/\u00a7e" + NumberUtil.INSTANCE.addSeparators(needForOnlyNextLevel) + "\u00a77)";
        }
        return "\u00a7aGarden level " + currentLevel + " " + string;
    }

    private final String toRomanIfNecessary(int $this$toRomanIfNecessary) {
        return this.getUseRomanNumerals() ? NumberUtil.INSTANCE.toRoman($this$toRomanIfNecessary) : String.valueOf($this$toRomanIfNecessary);
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (GardenApi.INSTANCE.hideExtraGuis()) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getPos(), display, 0, 0, "Garden Level", 6, null);
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Property[] propertyArray = new Property[]{this.getConfig().getOverflow()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, GardenLevelDisplay::onConfigLoad$lambda$7);
    }

    private final boolean isEnabled() {
        return GardenApi.INSTANCE.inGarden() && this.getConfig().getDisplay();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.gardenLevelDisplay", "garden.gardenLevels.display", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.gardenLevelPos", "garden.gardenLevels.pos", null, 8, null);
    }

    private static final Unit addExp$lambda$2$lambda$1() {
        HypixelCommands.INSTANCE.gardenLevels();
        return Unit.INSTANCE;
    }

    private static final Unit addExp$lambda$2(int $oldLevel, int $newLevel) {
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, " \n\u00a7b\u00a7lGARDEN LEVEL UP \u00a78" + $oldLevel + " \u279c \u00a7b" + $newLevel + "\n \u00a78+\u00a7aRespect from Elite Farmers and SkyHanni members :)\n ", GardenLevelDisplay::addExp$lambda$2$lambda$1, "\u00a7eClick to view your Garden Level progress and rewards!", 0L, false, null, false, false, 232, null);
        return Unit.INSTANCE;
    }

    private static final void onConfigLoad$lambda$7() {
        INSTANCE.update();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenLevelDisplay.class, "expToNextLevelPattern", "getExpToNextLevelPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenLevelDisplay.class, "gardenItemNamePattern", "getGardenItemNamePattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenLevelDisplay.class, "overflowPattern", "getOverflowPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenLevelDisplay.class, "gardenLevelPattern", "getGardenLevelPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenLevelDisplay.class, "gardenMaxLevelPattern", "getGardenMaxLevelPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenLevelDisplay.class, "visitorRewardPattern", "getVisitorRewardPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new GardenLevelDisplay();
        patternGroup = RepoPattern.Companion.group("garden.level");
        expToNextLevelPattern$delegate = patternGroup.pattern("inventory.nextxp", ".* \u00a7e(?<nextLevelExp>.*)\u00a76/.*");
        gardenItemNamePattern$delegate = patternGroup.pattern("inventory.name", "Garden (?:Desk|Level (?<currentLevel>.*))");
        overflowPattern$delegate = patternGroup.pattern("inventory.overflow", ".*\u00a7r \u00a76(?<overflow>.*)");
        gardenLevelPattern$delegate = patternGroup.pattern("inventory.levelprogress", "\u00a77Progress to Level (?<currentLevel>[^:]*).*");
        gardenMaxLevelPattern$delegate = patternGroup.pattern("inventory.max", "(?:\u00a75\u00a7o)?\u00a77\u00a78Max level reached!");
        visitorRewardPattern$delegate = patternGroup.pattern("chat.increase", " {4}\u00a7r\u00a78\\+\u00a7r\u00a72(?<exp>.*) \u00a7r\u00a77Garden Experience");
        display = "";
    }
}

