/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.itemabilities;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.itemability.ChickenHeadConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/itemabilities/ChickenHeadTimer;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/itemability/ChickenHeadConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/itemability/ChickenHeadConfig;", "config", "hasChickenHead", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastTime", "J", "Lkotlin/time/Duration;", "cooldown", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "chickenHead", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "1.21.10"})
public final class ChickenHeadTimer {
    @NotNull
    public static final ChickenHeadTimer INSTANCE = new ChickenHeadTimer();
    private static boolean hasChickenHead;
    private static long lastTime;
    private static final long cooldown;
    @NotNull
    private static final NeuInternalName chickenHead;

    private ChickenHeadTimer() {
    }

    private final ChickenHeadConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getItemAbilities().getChickenHead();
    }

    @HandleEvent
    public final void onTick(@NotNull SkyHanniTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!SkyHanniTickEvent.isMod$default(event, 5, 0, 2, null)) {
            return;
        }
        class_1799 class_17992 = InventoryUtils.INSTANCE.getHelmet();
        hasChickenHead = Intrinsics.areEqual((Object)(class_17992 != null ? ItemUtils.INSTANCE.getInternalName(class_17992) : null), (Object)chickenHead);
    }

    @HandleEvent
    public final void onWorldChange() {
        lastTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!hasChickenHead) {
            return;
        }
        if (Intrinsics.areEqual((Object)event.getMessage(), (Object)"\u00a7aYou laid an egg!")) {
            lastTime = SimpleTimeMark.Companion.now-uFjCsEo();
            if (this.getConfig().getHideChat()) {
                event.setBlockedReason("chicken_head_timer");
            }
        }
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!hasChickenHead) {
            return;
        }
        long remainingTime = Duration.minus-LRDsOJo((long)cooldown, (long)SimpleTimeMark.passedSince-UwyO8pc(lastTime));
        if (Duration.isNegative-impl((long)remainingTime)) {
            object = "Chicken Head Timer: \u00a7aNow";
        } else {
            String formatDuration = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, remainingTime, null, false, false, 0, false, false, 63, null);
            object = "Chicken Head Timer: \u00a7b" + formatDuration;
        }
        String displayText = object;
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), displayText, 0, 0, "Chicken Head Timer", 6, null);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.chickenHeadTimerHideChat", "itemAbilities.chickenHead.hideChat", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.chickenHeadTimerPosition", "itemAbilities.chickenHead.position", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.chickenHeadTimerDisplay", "itemAbilities.chickenHead.displayTimer", null, 8, null);
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getDisplayTimer();
    }

    static {
        lastTime = SimpleTimeMark.Companion.farPast();
        cooldown = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        chickenHead = NeuInternalName.Companion.toInternalName("CHICKEN_HEAD");
    }
}

