/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.items.enchants;

import at.hannibal2.skyhanni.features.misc.items.enchants.Enchant;
import at.hannibal2.skyhanni.features.misc.items.enchants.EnchantParser;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R>\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0013`\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR>\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u0012j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b`\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0016\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR>\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0\u0012j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f`\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u0016\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\u001a\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/features/misc/items/enchants/EnchantsJson;", "", "<init>", "()V", "", "passedLoreName", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant;", "getFromLore", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant;", "", "", "enchants", "line", "", "containsEnchantment", "(Ljava/util/Map;Ljava/lang/String;)Z", "hasEnchantData", "()Z", "Ljava/util/HashMap;", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant$Normal;", "Lkotlin/collections/HashMap;", "normal", "Ljava/util/HashMap;", "getNormal", "()Ljava/util/HashMap;", "setNormal", "(Ljava/util/HashMap;)V", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant$Ultimate;", "ultimate", "getUltimate", "setUltimate", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant$Stacking;", "stacking", "getStacking", "setStacking", "1.21.10"})
public final class EnchantsJson {
    @Expose
    @SerializedName(value="NORMAL")
    @NotNull
    private HashMap<String, Enchant.Normal> normal = new HashMap();
    @Expose
    @SerializedName(value="ULTIMATE")
    @NotNull
    private HashMap<String, Enchant.Ultimate> ultimate = new HashMap();
    @Expose
    @SerializedName(value="STACKING")
    @NotNull
    private HashMap<String, Enchant.Stacking> stacking = new HashMap();

    @NotNull
    public final HashMap<String, Enchant.Normal> getNormal() {
        return this.normal;
    }

    public final void setNormal(@NotNull HashMap<String, Enchant.Normal> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.normal = hashMap;
    }

    @NotNull
    public final HashMap<String, Enchant.Ultimate> getUltimate() {
        return this.ultimate;
    }

    public final void setUltimate(@NotNull HashMap<String, Enchant.Ultimate> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.ultimate = hashMap;
    }

    @NotNull
    public final HashMap<String, Enchant.Stacking> getStacking() {
        return this.stacking;
    }

    public final void setStacking(@NotNull HashMap<String, Enchant.Stacking> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.stacking = hashMap;
    }

    @NotNull
    public final Enchant getFromLore(@NotNull String passedLoreName) {
        Intrinsics.checkNotNullParameter((Object)passedLoreName, (String)"passedLoreName");
        String string = passedLoreName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String loreName = string;
        Enchant enchant = this.normal.get(loreName);
        if (enchant == null) {
            enchant = this.ultimate.get(loreName);
        }
        if (enchant == null) {
            enchant = this.stacking.get(loreName);
        }
        if (enchant == null) {
            enchant = new Enchant.Dummy(passedLoreName);
        }
        return enchant;
    }

    public final boolean containsEnchantment(@NotNull Map<String, Integer> enchants, @NotNull String line) {
        Intrinsics.checkNotNullParameter(enchants, (String)"enchants");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher exclusiveMatch = EnchantParser.INSTANCE.getEnchantmentExclusivePattern().matcher(line);
        if (!exclusiveMatch.find()) {
            return false;
        }
        Matcher matcher = EnchantParser.INSTANCE.getEnchantmentPattern().matcher(line);
        while (matcher.find()) {
            String key;
            String string = matcher.group("enchant");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            Enchant enchant = this.getFromLore(string);
            if (!enchants.isEmpty()) {
                if (!enchants.containsKey(enchant.getNbtName())) continue;
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)enchant.getLoreName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!this.normal.containsKey(key) && !this.ultimate.containsKey(key) && !this.stacking.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasEnchantData() {
        return !((Map)this.normal).isEmpty() && !((Map)this.ultimate).isEmpty() && !((Map)this.stacking).isEmpty();
    }
}

