/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import net.minecraft.class_1953;
import net.replaceitem.integratedcircuit.circuit.CircuitTickScheduler;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.OrderedCircuitTick;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;

public interface CircuitAccess {
    public CircuitTickScheduler getCircuitTickScheduler();

    public long getTime();

    public long getTickOrder();

    default public void scheduleBlockTick(ComponentPos pos, Component component, int delay, class_1953 priority) {
        this.getCircuitTickScheduler().scheduleTick(this.createOrderedTick(pos, component, delay, priority));
    }

    default public void scheduleBlockTick(ComponentPos pos, Component component, int delay) {
        this.getCircuitTickScheduler().scheduleTick(this.createOrderedTick(pos, component, delay));
    }

    private OrderedCircuitTick createOrderedTick(ComponentPos pos, Component type, int delay, class_1953 priority) {
        return new OrderedCircuitTick(type, pos, this.getTime() + (long)delay, priority, this.getTickOrder());
    }

    private OrderedCircuitTick createOrderedTick(ComponentPos pos, Component type, int delay) {
        return new OrderedCircuitTick(type, pos, this.getTime() + (long)delay, this.getTickOrder());
    }

    default public void updateNeighbors(ComponentPos pos, Component component) {
    }

    default public void updateNeighborsExcept(ComponentPos pos, Component sourceComponent, FlatDirection direction) {
    }

    default public void updateNeighborsAlways(ComponentPos pos, Component sourceComponent) {
    }

    default public void updateNeighbor(ComponentPos pos, Component sourceComponent, ComponentPos sourcePos) {
    }

    default public void updateNeighbor(ComponentState state, ComponentPos pos, Component sourceComponent, ComponentPos sourcePos, boolean notify) {
    }

    default public void replaceWithStateForNeighborUpdate(FlatDirection direction, ComponentState neighborState, ComponentPos pos, ComponentPos neighborPos, int flags, int maxUpdateDepth) {
    }
}

