/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.CircuitNeighborUpdater;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class TorchComponent
extends FacingComponent {
    private static final class_2960 ITEM_TEXTURE = class_2960.method_60656((String)"textures/block/redstone_torch.png");
    private static final class_2960 TOOL_TEXTURE = IntegratedCircuit.id("toolbox/icons/torch");
    private static final class_2960 TEXTURE = IntegratedCircuit.id("textures/integrated_circuit/torch.png");
    private static final class_2960 TEXTURE_OFF = IntegratedCircuit.id("textures/integrated_circuit/torch_off.png");
    public static final class_2746 LIT = class_2741.field_12548;
    private static final Map<ServerCircuit, List<BurnoutEntry>> BURNOUT_MAP = new WeakHashMap<ServerCircuit, List<BurnoutEntry>>();

    public TorchComponent(Component.Settings settings) {
        super(settings);
        this.setDefaultState((ComponentState)((Object)this.getDefaultState().method_11657((class_2769)LIT, Boolean.valueOf(true))));
    }

    @Override
    public ComponentState getPlacementState(Circuit circuit, ComponentPos pos, FlatDirection rotation) {
        ComponentState componentState = (ComponentState)((Object)this.getDefaultState().method_11657((class_2769)FACING, (Comparable)((Object)rotation)));
        if (!componentState.canPlaceAt(circuit, pos)) {
            for (FlatDirection value : CircuitNeighborUpdater.UPDATE_ORDER) {
                if (!(componentState = (ComponentState)((Object)componentState.method_11657((class_2769)FACING, (Comparable)((Object)value)))).canPlaceAt(circuit, pos)) continue;
                return componentState;
            }
            return null;
        }
        return componentState;
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return ITEM_TEXTURE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return TOOL_TEXTURE;
    }

    @Override
    public class_2561 getHoverInfoText(ComponentState state) {
        return IntegratedCircuitScreen.getSignalStrengthText((Boolean)state.method_11654((class_2769)LIT) != false ? 15 : 0);
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        class_2960 texture = (Boolean)state.method_11654((class_2769)LIT) != false ? TEXTURE : TEXTURE_OFF;
        IntegratedCircuitScreen.renderComponentTexture(drawContext, texture, x, y, ((FlatDirection)((Object)state.method_11654((class_2769)FACING))).getIndex(), a);
    }

    @Override
    public ComponentState getStateForNeighborUpdate(ComponentState state, FlatDirection direction, ComponentState neighborState, Circuit circuit, ComponentPos pos, ComponentPos neighborPos) {
        if (direction.getOpposite() == state.method_11654((class_2769)FACING) && !this.canPlaceAt(state, circuit, pos)) {
            return Components.AIR.getDefaultState();
        }
        return state;
    }

    @Override
    public boolean canPlaceAt(ComponentState state, Circuit circuit, ComponentPos pos) {
        FlatDirection direction = (FlatDirection)((Object)state.method_11654((class_2769)FACING));
        ComponentPos blockPos = pos.offset(direction.getOpposite());
        ComponentState blockState = circuit.getComponentState(blockPos);
        return blockState.getComponent().isSideSolidFullSquare(circuit, blockPos, direction);
    }

    @Override
    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
        for (FlatDirection direction : FlatDirection.VALUES) {
            circuit.updateNeighborsAlways(pos.offset(direction), this);
        }
    }

    @Override
    public void onStateReplaced(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState newState) {
        for (FlatDirection direction : FlatDirection.VALUES) {
            circuit.updateNeighborsAlways(pos.offset(direction), this);
        }
    }

    @Override
    public void scheduledTick(ComponentState state, ServerCircuit circuit, ComponentPos pos, class_5819 random) {
        boolean shouldUnpower = this.shouldUnpower(circuit, pos, state);
        List<BurnoutEntry> list = BURNOUT_MAP.get(circuit);
        while (list != null && !list.isEmpty() && circuit.getTime() - list.getFirst().time > 60L) {
            list.removeFirst();
        }
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            if (shouldUnpower) {
                circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)LIT, Boolean.valueOf(false))), 3);
                if (TorchComponent.isBurnedOut(circuit, pos, true)) {
                    circuit.playSound(null, class_3417.field_19199, class_3419.field_15245, 1.0f, 2.6f + (random.method_43057() - random.method_43057()) * 0.8f);
                    circuit.scheduleBlockTick(pos, circuit.getComponentState(pos).getComponent(), 160);
                }
            }
        } else if (!shouldUnpower && !TorchComponent.isBurnedOut(circuit, pos, false)) {
            circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)LIT, Boolean.valueOf(true))), 3);
        }
    }

    @Override
    public void neighborUpdate(ComponentState state, Circuit circuit, ComponentPos pos, Component sourceBlock, ComponentPos sourcePos, boolean notify) {
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue() == this.shouldUnpower(circuit, pos, state) && !circuit.getCircuitTickScheduler().isTicking(pos, this)) {
            circuit.scheduleBlockTick(pos, this, 2);
        }
    }

    @Override
    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return (Boolean)state.method_11654((class_2769)LIT) != false && state.method_11654((class_2769)FACING) != direction ? 15 : 0;
    }

    @Override
    public boolean isSolidBlock(Circuit circuit, ComponentPos pos) {
        return false;
    }

    protected boolean shouldUnpower(Circuit circuit, ComponentPos pos, ComponentState state) {
        FlatDirection direction = ((FlatDirection)((Object)state.method_11654((class_2769)FACING))).getOpposite();
        return circuit.isEmittingRedstonePower(pos.offset(direction), direction);
    }

    private static boolean isBurnedOut(ServerCircuit circuit, ComponentPos pos, boolean addNew) {
        List list = BURNOUT_MAP.computeIfAbsent(circuit, world -> Lists.newArrayList());
        if (addNew) {
            list.add(new BurnoutEntry(pos, circuit.getTime()));
        }
        int i = 0;
        for (BurnoutEntry burnoutEntry : list) {
            if (!burnoutEntry.pos.equals((Object)pos) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean emitsRedstonePower(ComponentState state) {
        return true;
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{LIT});
    }

    public static class BurnoutEntry {
        final ComponentPos pos;
        final long time;

        public BurnoutEntry(ComponentPos pos, long time) {
            this.pos = pos;
            this.time = time;
        }
    }
}

