/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_2382;
import net.minecraft.class_9139;
import net.replaceitem.integratedcircuit.util.FlatDirection;

public class ComponentPos
extends class_2382 {
    public static final MapCodec<ComponentPos> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(class_2382::method_10263), (App)Codec.INT.fieldOf("y").forGetter(class_2382::method_10264)).apply((Applicative)instance, ComponentPos::new));
    public static final class_9139<ByteBuf, ComponentPos> PACKET_CODEC = new class_9139<ByteBuf, ComponentPos>(){

        public ComponentPos decode(ByteBuf byteBuf) {
            short x = byteBuf.readShort();
            short y = byteBuf.readShort();
            return new ComponentPos(x, y);
        }

        public void encode(ByteBuf byteBuf, ComponentPos pos) {
            byteBuf.writeShort(pos.method_10263());
            byteBuf.writeShort(pos.method_10264());
        }
    };

    public ComponentPos(int x, int y) {
        super(x, y, 0);
    }

    public ComponentPos add(int x, int y) {
        return new ComponentPos(this.method_10263() + x, this.method_10264() + y);
    }

    public ComponentPos add(class_2382 vec3i) {
        return this.add(vec3i.method_10263(), vec3i.method_10264());
    }

    public ComponentPos multiply(int amount) {
        return new ComponentPos(this.method_10263() * amount, this.method_10264() * amount);
    }

    public ComponentPos offset(FlatDirection direction, int amount) {
        return this.add(direction.getOffset().method_35862(amount));
    }

    public ComponentPos offset(FlatDirection direction) {
        return this.add(direction.getOffset());
    }

    public ComponentPos north() {
        return this.offset(FlatDirection.NORTH);
    }

    public ComponentPos east() {
        return this.offset(FlatDirection.EAST);
    }

    public ComponentPos south() {
        return this.offset(FlatDirection.SOUTH);
    }

    public ComponentPos west() {
        return this.offset(FlatDirection.WEST);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ComponentPos)) return false;
        ComponentPos componentPos = (ComponentPos)((Object)o);
        if (this.method_10263() != componentPos.method_10263()) return false;
        if (this.method_10264() != componentPos.method_10264()) return false;
        return true;
    }
}

