/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.class_1657;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.replaceitem.integratedcircuit.circuit.CircuitAccess;
import net.replaceitem.integratedcircuit.circuit.CircuitNeighborUpdater;
import net.replaceitem.integratedcircuit.circuit.CircuitSection;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.components.PortComponent;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public abstract class Circuit
implements CircuitAccess {
    public static final int SIZE = 15;
    public static final int PORT_COUNT = FlatDirection.VALUES.length;
    public static final Codec<ComponentState[]> PORTS_CODEC = ComponentState.CODEC.listOf(PORT_COUNT, PORT_COUNT).xmap(componentStates -> (ComponentState[])componentStates.toArray(ComponentState[]::new), Arrays::asList);
    public static final BiMap<FlatDirection, ComponentPos> PORT_POSITIONS = EnumHashBiMap.create(FlatDirection.class);
    protected final CircuitSection section;
    protected final ComponentState[] ports;
    protected final CircuitNeighborUpdater neighborUpdater = new CircuitNeighborUpdater(this);
    public final boolean isClient;
    private long tickOrder;

    public Circuit(boolean isClient) {
        this.isClient = isClient;
        this.ports = Circuit.createDefaultPorts();
        this.section = new CircuitSection();
    }

    public Circuit(boolean isClient, ComponentState[] portStates, CircuitSection section) {
        this.isClient = isClient;
        this.ports = portStates;
        this.section = section;
    }

    public ComponentState[] getPorts() {
        return this.ports;
    }

    public CircuitSection getSection() {
        return this.section;
    }

    public static ComponentState[] createDefaultPorts() {
        ComponentState[] ports = new ComponentState[PORT_COUNT];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (ComponentState)((Object)Components.PORT.getDefaultState().method_11657((class_2769)PortComponent.FACING, (Comparable)((Object)FlatDirection.VALUES[i].getOpposite())));
        }
        return ports;
    }

    public boolean isInside(ComponentPos pos) {
        return pos.method_10263() >= 0 && pos.method_10263() < 15 && pos.method_10264() >= 0 && pos.method_10264() < 15;
    }

    @Override
    public abstract long getTime();

    public boolean isValidPos(ComponentPos pos) {
        return this.isInside(pos) || Circuit.isPortPos(pos);
    }

    public ComponentState getComponentState(ComponentPos componentPos) {
        if (this.isInside(componentPos)) {
            return this.section.getComponentState(componentPos.method_10263(), componentPos.method_10264());
        }
        FlatDirection portSide = Circuit.getPortSide(componentPos);
        if (portSide != null) {
            return this.ports[portSide.getIndex()];
        }
        return Components.AIR.getDefaultState();
    }

    protected ComponentState assignComponentState(ComponentPos pos, ComponentState state) {
        ComponentState oldState = this.getComponentState(pos);
        FlatDirection portSide = Circuit.getPortSide(pos);
        if (portSide != null) {
            if (!state.isOf(Components.PORT)) {
                throw new RuntimeException("Cannot place non-port component at a port location");
            }
            this.ports[portSide.getIndex()] = state;
        } else {
            this.section.setComponentState(pos, state);
        }
        return oldState;
    }

    public boolean setComponentState(ComponentPos pos, ComponentState state, int flags) {
        return this.setComponentState(pos, state, flags, 512);
    }

    public boolean setComponentState(ComponentPos pos, ComponentState state, int flags, int maxUpdateDepth) {
        ComponentState placedComponentState;
        ComponentState oldState;
        if (!this.isValidPos(pos)) {
            return false;
        }
        if (state == null) {
            state = Components.AIR_DEFAULT_STATE;
        }
        if ((oldState = this.assignComponentState(pos, state)) == state) {
            return false;
        }
        if (!this.isClient) {
            oldState.onStateReplaced(this, pos, state);
        }
        if (!this.isClient) {
            state.onBlockAdded(this, pos, oldState);
        }
        if ((placedComponentState = this.getComponentState(pos)) == state) {
            if (!((flags & 2) == 0 || this.isClient && (flags & 4) != 0)) {
                this.updateListeners(pos, oldState, state, flags);
            }
            if ((flags & 1) != 0) {
                this.updateNeighbors(pos, oldState.getComponent());
                if (!this.isClient && state.hasComparatorOutput()) {
                    this.updateComparators(pos, state.getComponent());
                }
            }
            if ((flags & 0x10) == 0 && maxUpdateDepth > 0) {
                int i = flags & 0xFFFFFFDE;
                oldState.prepare(this, pos, i, maxUpdateDepth - 1);
                state.updateNeighbors(this, pos, i, maxUpdateDepth - 1);
                state.prepare(this, pos, i, maxUpdateDepth - 1);
            }
        }
        return true;
    }

    @Nullable
    public static FlatDirection getPortSide(ComponentPos pos) {
        return (FlatDirection)((Object)PORT_POSITIONS.inverse().get((Object)pos));
    }

    public static boolean isPortPos(ComponentPos pos) {
        return Circuit.getPortSide(pos) != null;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.ports.length; ++i) {
            if (this.ports[i].method_11654((class_2769)PortComponent.FACING) == FlatDirection.VALUES[i].getOpposite()) continue;
            return false;
        }
        return this.section.isEmpty();
    }

    protected abstract void updateListeners(ComponentPos var1, ComponentState var2, ComponentState var3, int var4);

    @Override
    public void replaceWithStateForNeighborUpdate(FlatDirection direction, ComponentState neighborState, ComponentPos pos, ComponentPos neighborPos, int flags, int maxUpdateDepth) {
        this.neighborUpdater.replaceWithStateForNeighborUpdate(direction, neighborState, pos, neighborPos, flags);
    }

    public int getEmittedRedstonePower(ComponentPos pos, FlatDirection direction) {
        ComponentState blockState = this.getComponentState(pos);
        int i = blockState.getWeakRedstonePower(this, pos, direction);
        if (blockState.isSolidBlock(this, pos)) {
            return Math.max(i, this.getReceivedStrongRedstonePower(pos));
        }
        return i;
    }

    public boolean isEmittingRedstonePower(ComponentPos pos, FlatDirection direction) {
        return this.getEmittedRedstonePower(pos, direction) > 0;
    }

    private int getReceivedStrongRedstonePower(ComponentPos pos) {
        int i = 0;
        if ((i = Math.max(i, this.getStrongRedstonePower(pos.north(), FlatDirection.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongRedstonePower(pos.south(), FlatDirection.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongRedstonePower(pos.west(), FlatDirection.WEST))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongRedstonePower(pos.east(), FlatDirection.EAST))) >= 15) {
            return i;
        }
        return i;
    }

    public int getStrongRedstonePower(ComponentPos pos, FlatDirection direction) {
        return this.getComponentState(pos).getStrongRedstonePower(this, pos, direction);
    }

    public int getReceivedRedstonePower(ComponentPos pos) {
        int i = 0;
        for (FlatDirection direction : FlatDirection.VALUES) {
            int j = this.getEmittedRedstonePower(pos.offset(direction), direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public boolean isReceivingRedstonePower(ComponentPos pos) {
        if (this.getEmittedRedstonePower(pos.north(), FlatDirection.NORTH) > 0) {
            return true;
        }
        if (this.getEmittedRedstonePower(pos.south(), FlatDirection.SOUTH) > 0) {
            return true;
        }
        if (this.getEmittedRedstonePower(pos.west(), FlatDirection.WEST) > 0) {
            return true;
        }
        return this.getEmittedRedstonePower(pos.east(), FlatDirection.EAST) > 0;
    }

    public void useComponent(ComponentPos pos, class_1657 player) {
        ComponentState state = this.getComponentState(pos);
        state.onUse(this, pos, player);
    }

    public void updateComparators(ComponentPos pos, Component component) {
        for (FlatDirection direction : FlatDirection.VALUES) {
            ComponentPos offsetPos = pos.offset(direction);
            ComponentState state = this.getComponentState(offsetPos);
            if (state.isOf(Components.COMPARATOR)) {
                this.updateNeighbor(state, offsetPos, component, pos, false);
                continue;
            }
            if (!state.isSolidBlock(this, offsetPos) || !(state = this.getComponentState(offsetPos = offsetPos.offset(direction))).isOf(Components.COMPARATOR)) continue;
            this.updateNeighbor(state, offsetPos, component, pos, false);
        }
    }

    public boolean removeBlock(ComponentPos pos) {
        return this.setComponentState(pos, Components.AIR_DEFAULT_STATE, 3);
    }

    public abstract void placeComponentState(ComponentPos var1, Component var2, FlatDirection var3);

    @Override
    public long getTickOrder() {
        return this.tickOrder++;
    }

    public boolean breakBlock(ComponentPos pos) {
        return this.breakBlock(pos, 512);
    }

    public boolean breakBlock(ComponentPos pos, int maxUpdateDepth) {
        ComponentState blockState = this.getComponentState(pos);
        if (blockState.isAir()) {
            return false;
        }
        return this.setComponentState(pos, Components.AIR_DEFAULT_STATE, 3, maxUpdateDepth);
    }

    public final void playSound(@Nullable class_1657 except, class_3414 sound, class_3419 category, float volume, float pitch) {
        this.playSoundInternal(except, sound, category, volume, pitch * 1.6f);
    }

    protected abstract void playSoundInternal(@Nullable class_1657 var1, class_3414 var2, class_3419 var3, float var4, float var5);

    static {
        PORT_POSITIONS.put((Object)FlatDirection.NORTH, (Object)new ComponentPos(7, -1));
        PORT_POSITIONS.put((Object)FlatDirection.EAST, (Object)new ComponentPos(15, 7));
        PORT_POSITIONS.put((Object)FlatDirection.SOUTH, (Object)new ComponentPos(7, 15));
        PORT_POSITIONS.put((Object)FlatDirection.WEST, (Object)new ComponentPos(-1, 7));
    }
}

