/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.CircuitSection;
import net.replaceitem.integratedcircuit.circuit.ClientCircuit;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.context.ClientCircuitContext;
import net.replaceitem.integratedcircuit.circuit.context.ServerCircuitContext;
import org.slf4j.Logger;

public class CircuitSerializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String SECTION_TAG = "section";
    public static final String COMPONENT_STATES_TAG = "component_states";
    public static final String PORTS_TAG = "ports";
    public static final String TICK_SCHEDULER_TAG = "tickScheduler";
    private final class_2487 root;

    public CircuitSerializer(class_2487 nbt) {
        this.root = nbt;
    }

    public ServerCircuit readServerCircuit(ServerCircuitContext context) {
        return ServerCircuit.CODEC.parse(context, class_2509.field_11560, this.root).result().orElseGet(() -> new ServerCircuit(context));
    }

    public ClientCircuit readClientCircuit(ClientCircuitContext context) {
        return new ClientCircuit(context, this.readPortStates(), this.readSection());
    }

    private ComponentState[] readPortStates() {
        return this.root.method_10554(PORTS_TAG).filter(nbtElements -> nbtElements.size() == 4).map(ports -> (ComponentState[])ports.stream().map(nbtElement -> ComponentState.CODEC.parse((DynamicOps)class_2509.field_11560, nbtElement).result().orElse(Components.AIR_DEFAULT_STATE)).toArray(ComponentState[]::new)).orElseGet(Circuit::createDefaultPorts);
    }

    public CircuitSection readSection() {
        return this.root.method_10562(SECTION_TAG).flatMap(sectionNbt -> sectionNbt.method_10562(COMPONENT_STATES_TAG)).flatMap(componentStatesNbt -> CircuitSection.PALETTE_CODEC.parse((DynamicOps)class_2509.field_11560, componentStatesNbt).promotePartial(errorMessage -> LOGGER.error("Could not load circuit: {}", errorMessage)).result()).map(CircuitSection::new).orElseGet(CircuitSection::new);
    }

    public static DataResult<class_2520> writeCircuit(ServerCircuit circuit) {
        return ServerCircuit.CODEC.encodeStart(circuit.getContext(), class_2509.field_11560, circuit);
    }
}

