/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import org.jetbrains.annotations.Nullable;

public class CopperBulbComponent
extends Component {
    private static final class_2960 ITEM_TEXTURE = IntegratedCircuit.id("textures/integrated_circuit/copper_bulb.png");
    private static final class_2960 TOOL_TEXTURE = IntegratedCircuit.id("toolbox/icons/copper_bulb");
    private static final class_2960 TEXTURE_LIT = IntegratedCircuit.id("textures/integrated_circuit/copper_bulb_lit.png");
    private static final class_2960 TEXTURE_POWERED = IntegratedCircuit.id("textures/integrated_circuit/copper_bulb_powered.png");
    private static final class_2960 TEXTURE_LIT_POWERED = IntegratedCircuit.id("textures/integrated_circuit/copper_bulb_lit_powered.png");
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 POWERED = class_2741.field_12484;

    public CopperBulbComponent(Component.Settings settings) {
        super(settings);
        this.setDefaultState((ComponentState)((Object)((ComponentState)((Object)((ComponentState)this.getStateManager().method_11664()).method_11657((class_2769)LIT, Boolean.valueOf(false)))).method_11657((class_2769)POWERED, Boolean.valueOf(false))));
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return ITEM_TEXTURE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return TOOL_TEXTURE;
    }

    private class_2960 getTexture(boolean lit, boolean powered) {
        return lit ? (powered ? TEXTURE_LIT_POWERED : TEXTURE_LIT) : (powered ? TEXTURE_POWERED : ITEM_TEXTURE);
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        IntegratedCircuitScreen.renderComponentTexture(drawContext, this.getTexture((Boolean)state.method_11654((class_2769)LIT), (Boolean)state.method_11654((class_2769)POWERED)), x, y, 0, a);
    }

    @Override
    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
        if (oldState.getComponent() != state.getComponent() && circuit instanceof ServerCircuit) {
            ServerCircuit serverCircuit = (ServerCircuit)circuit;
            this.update(state, serverCircuit, pos);
        }
    }

    @Override
    public void neighborUpdate(ComponentState state, Circuit circuit, ComponentPos pos, Component sourceBlock, ComponentPos sourcePos, boolean notify) {
        if (circuit instanceof ServerCircuit) {
            ServerCircuit serverCircuit = (ServerCircuit)circuit;
            this.update(state, serverCircuit, pos);
        }
    }

    public void update(ComponentState state, ServerCircuit circuit, ComponentPos pos) {
        boolean receivingPower = circuit.isReceivingRedstonePower(pos);
        if (receivingPower != (Boolean)state.method_11654((class_2769)POWERED)) {
            ComponentState newState = state;
            if (receivingPower) {
                circuit.playSound(null, (Boolean)(newState = (ComponentState)((Object)newState.method_28493((class_2769)LIT))).method_11654((class_2769)LIT) != false ? class_3417.field_46934 : class_3417.field_46935, class_3419.field_15245, 1.0f, 1.0f);
            }
            circuit.setComponentState(pos, (ComponentState)((Object)newState.method_11657((class_2769)POWERED, Boolean.valueOf(receivingPower))), 3);
        }
    }

    @Override
    public boolean isSolidBlock(Circuit circuit, ComponentPos pos) {
        return true;
    }

    @Override
    public boolean hasComparatorOutput(ComponentState componentState) {
        return true;
    }

    @Override
    public int getComparatorOutput(ComponentState state, Circuit circuit, ComponentPos pos) {
        return (Boolean)state.method_11654((class_2769)LIT) != false ? 15 : 0;
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{LIT, POWERED});
    }
}

