/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class ObserverComponent
extends FacingComponent {
    public static final class_2960 ITEM_TEXTURE = IntegratedCircuit.id("textures/integrated_circuit/observer.png");
    public static final class_2960 TOOL_TEXTURE = IntegratedCircuit.id("toolbox/icons/observer");
    public static final class_2960 TEXTURE_ON = IntegratedCircuit.id("textures/integrated_circuit/observer_on.png");
    public static final class_2746 POWERED = class_2741.field_12484;

    public ObserverComponent(Component.Settings settings) {
        super(settings);
        this.setDefaultState((ComponentState)((Object)((ComponentState)((Object)((ComponentState)this.getStateManager().method_11664()).method_11657((class_2769)FACING, (Comparable)((Object)FlatDirection.NORTH)))).method_11657((class_2769)POWERED, Boolean.valueOf(false))));
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return ITEM_TEXTURE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return TOOL_TEXTURE;
    }

    @Override
    public class_2561 getHoverInfoText(ComponentState state) {
        return IntegratedCircuitScreen.getSignalStrengthText((Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0);
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        IntegratedCircuitScreen.renderComponentTexture(drawContext, (Boolean)state.method_11654((class_2769)POWERED) != false ? TEXTURE_ON : ITEM_TEXTURE, x, y, ((FlatDirection)((Object)state.method_11654((class_2769)FACING))).getOpposite().getIndex(), a);
    }

    @Override
    public void scheduledTick(ComponentState state, ServerCircuit circuit, ComponentPos pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(false))), 2);
        } else {
            circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(true))), 2);
            circuit.scheduleBlockTick(pos, this, 2);
        }
        this.updateNeighbors(circuit, pos, state);
    }

    @Override
    public ComponentState getStateForNeighborUpdate(ComponentState state, FlatDirection direction, ComponentState neighborState, Circuit circuit, ComponentPos pos, ComponentPos neighborPos) {
        if (state.method_11654((class_2769)FACING) == direction && !((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            this.scheduleTick(circuit, pos);
        }
        return super.getStateForNeighborUpdate(state, direction, neighborState, circuit, pos, neighborPos);
    }

    private void scheduleTick(Circuit circuit, ComponentPos pos) {
        if (!circuit.isClient && !circuit.getCircuitTickScheduler().isQueued(pos, this)) {
            circuit.scheduleBlockTick(pos, this, 2);
        }
    }

    protected void updateNeighbors(Circuit world, ComponentPos pos, ComponentState state) {
        FlatDirection direction = (FlatDirection)((Object)state.method_11654((class_2769)FACING));
        ComponentPos blockPos = pos.offset(direction.getOpposite());
        world.updateNeighbor(blockPos, this, pos);
        world.updateNeighborsExcept(blockPos, this, direction);
    }

    @Override
    public boolean emitsRedstonePower(ComponentState state) {
        return true;
    }

    @Override
    public int getStrongRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return state.getWeakRedstonePower(circuit, pos, direction);
    }

    @Override
    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() && state.method_11654((class_2769)FACING) == direction) {
            return 15;
        }
        return 0;
    }

    @Override
    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
        if (state.isOf(oldState.getComponent())) {
            return;
        }
        if (!circuit.isClient && ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() && !circuit.getCircuitTickScheduler().isQueued(pos, this)) {
            ComponentState blockState = (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(false)));
            circuit.setComponentState(pos, blockState, 18);
            this.updateNeighbors(circuit, pos, blockState);
        }
    }

    @Override
    public void onStateReplaced(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState newState) {
        if (state.isOf(newState.getComponent())) {
            return;
        }
        if (!circuit.isClient && ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() && circuit.getCircuitTickScheduler().isQueued(pos, this)) {
            this.updateNeighbors(circuit, pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(false))));
        }
    }

    @Override
    public boolean isSolidBlock(Circuit circuit, ComponentPos pos) {
        return false;
    }

    @Override
    public boolean isSideSolidFullSquare(Circuit circuit, ComponentPos blockPos, FlatDirection direction) {
        return true;
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{POWERED});
    }
}

