/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2457;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.components.AbstractWireComponent;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class WireComponent
extends AbstractWireComponent {
    private static final class_2960 ITEM_TEXTURE = class_2960.method_60656((String)"textures/item/redstone.png");
    private static final class_2960 TOOL_TEXTURE = IntegratedCircuit.id("toolbox/icons/redstone");
    private static final class_2960 TEXTURE_DOT = IntegratedCircuit.id("textures/integrated_circuit/wire_dot.png");
    public static final class_2746 CONNECTED_NORTH = class_2746.method_11825((String)"connected_north");
    public static final class_2746 CONNECTED_EAST = class_2746.method_11825((String)"connected_east");
    public static final class_2746 CONNECTED_SOUTH = class_2746.method_11825((String)"connected_south");
    public static final class_2746 CONNECTED_WEST = class_2746.method_11825((String)"connected_west");
    public static final class_2758 POWER = class_2741.field_12511;
    public static final Map<FlatDirection, class_2746> DIRECTION_TO_CONNECTION_PROPERTY = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)FlatDirection.NORTH), (Object)CONNECTED_NORTH, (Object)((Object)FlatDirection.EAST), (Object)CONNECTED_EAST, (Object)((Object)FlatDirection.SOUTH), (Object)CONNECTED_SOUTH, (Object)((Object)FlatDirection.WEST), (Object)CONNECTED_WEST));
    private final ComponentState dotState;

    public WireComponent(Component.Settings settings) {
        super(settings);
        this.setDefaultState((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)this.getStateManager().method_11664()).method_11657((class_2769)CONNECTED_NORTH, Boolean.valueOf(false)))).method_11657((class_2769)CONNECTED_EAST, Boolean.valueOf(false)))).method_11657((class_2769)CONNECTED_SOUTH, Boolean.valueOf(false)))).method_11657((class_2769)CONNECTED_WEST, Boolean.valueOf(false)))).method_11657((class_2769)POWER, Integer.valueOf(0))));
        this.dotState = (ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)((ComponentState)((Object)this.getDefaultState().method_11657((class_2769)CONNECTED_NORTH, Boolean.valueOf(true)))).method_11657((class_2769)CONNECTED_EAST, Boolean.valueOf(true)))).method_11657((class_2769)CONNECTED_SOUTH, Boolean.valueOf(true)))).method_11657((class_2769)CONNECTED_WEST, Boolean.valueOf(true)))).method_11657((class_2769)POWER, Integer.valueOf(0)));
    }

    @Override
    public ComponentState getPlacementState(Circuit circuit, ComponentPos pos, FlatDirection rotation) {
        return this.getPlacementState(circuit, this.dotState, pos);
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return ITEM_TEXTURE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return TOOL_TEXTURE;
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        int size = 16;
        int halfSize = 8;
        int color = class_9848.method_61330((int)class_9848.method_61326((float)a), (int)class_2457.method_10487((int)((Integer)state.method_11654((class_2769)POWER))));
        if (((Boolean)state.method_11654((class_2769)CONNECTED_NORTH)).booleanValue()) {
            IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_Y, x, y, 0, color, 0, 0, 16, 8);
        }
        if (((Boolean)state.method_11654((class_2769)CONNECTED_EAST)).booleanValue()) {
            IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_X, x, y, 0, color, 8, 0, 8, 16);
        }
        if (((Boolean)state.method_11654((class_2769)CONNECTED_SOUTH)).booleanValue()) {
            IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_Y, x, y, 0, color, 0, 8, 16, 8);
        }
        if (((Boolean)state.method_11654((class_2769)CONNECTED_WEST)).booleanValue()) {
            IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_X, x, y, 0, color, 0, 0, 8, 16);
        }
        int connections = 0;
        for (FlatDirection direction : FlatDirection.VALUES) {
            if (!((Boolean)state.method_11654((class_2769)DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction))).booleanValue()) continue;
            ++connections;
        }
        if (connections != 2) {
            IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_DOT, x, y, 0, color, 0, 0, 16, 16);
        }
        if (!(((Boolean)state.method_11654((class_2769)CONNECTED_NORTH)).booleanValue() && ((Boolean)state.method_11654((class_2769)CONNECTED_SOUTH)).booleanValue() || ((Boolean)state.method_11654((class_2769)CONNECTED_EAST)).booleanValue() && ((Boolean)state.method_11654((class_2769)CONNECTED_WEST)).booleanValue())) {
            IntegratedCircuitScreen.renderComponentTexture(drawContext, TEXTURE_DOT, x, y, 0, color, 0, 0, 16, 16);
        }
    }

    @Override
    public ComponentState getStateForNeighborUpdate(ComponentState state, FlatDirection direction, ComponentState neighborState, Circuit circuit, ComponentPos pos, ComponentPos neighborPos) {
        boolean wireConnection = this.getRenderConnectionType(circuit, pos, direction);
        if (wireConnection == (Boolean)state.method_11654((class_2769)DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction)) && !WireComponent.isFullyConnected(state)) {
            return (ComponentState)((Object)state.method_11657((class_2769)DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction), Boolean.valueOf(wireConnection)));
        }
        return this.getPlacementState(circuit, (ComponentState)((Object)((ComponentState)((Object)this.dotState.method_11657((class_2769)POWER, (Integer)state.method_11654((class_2769)POWER)))).method_11657((class_2769)DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction), Boolean.valueOf(wireConnection))), pos);
    }

    @Override
    public void onUse(ComponentState state, Circuit circuit, ComponentPos pos, class_1657 player) {
        if (WireComponent.isFullyConnected(state) || WireComponent.isNotConnected(state)) {
            ComponentState newState = WireComponent.isFullyConnected(state) ? this.getDefaultState() : this.dotState;
            newState = (ComponentState)((Object)newState.method_11657((class_2769)POWER, (Integer)state.method_11654((class_2769)POWER)));
            if ((newState = this.getPlacementState(circuit, newState, pos)) != state) {
                circuit.setComponentState(pos, newState, 3);
                this.updateForNewState(circuit, pos, state, newState);
            }
        }
    }

    private void updateForNewState(Circuit world, ComponentPos pos, ComponentState oldState, ComponentState newState) {
        for (FlatDirection direction : FlatDirection.VALUES) {
            ComponentPos blockPos = pos.offset(direction);
            class_2746 connectionProperty = DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction);
            if (oldState.method_11654((class_2769)connectionProperty) == newState.method_11654((class_2769)connectionProperty) || !world.getComponentState(blockPos).isSolidBlock(world, blockPos)) continue;
            world.updateNeighborsExcept(blockPos, newState.getComponent(), direction.getOpposite());
        }
    }

    private ComponentState getPlacementState(Circuit circuit, ComponentState state, ComponentPos pos) {
        boolean ew;
        boolean notConnected = WireComponent.isNotConnected(state);
        state = this.getDefaultWireState(circuit, (ComponentState)((Object)this.getDefaultState().method_11657((class_2769)POWER, (Integer)state.method_11654((class_2769)POWER))), pos);
        if (notConnected && WireComponent.isNotConnected(state)) {
            return state;
        }
        boolean n = (Boolean)state.method_11654((class_2769)CONNECTED_NORTH);
        boolean s = (Boolean)state.method_11654((class_2769)CONNECTED_SOUTH);
        boolean e = (Boolean)state.method_11654((class_2769)CONNECTED_EAST);
        boolean w = (Boolean)state.method_11654((class_2769)CONNECTED_WEST);
        boolean ns = !n && !s;
        boolean bl = ew = !e && !w;
        if (!w && ns) {
            state = (ComponentState)((Object)state.method_11657((class_2769)CONNECTED_WEST, Boolean.valueOf(true)));
        }
        if (!e && ns) {
            state = (ComponentState)((Object)state.method_11657((class_2769)CONNECTED_EAST, Boolean.valueOf(true)));
        }
        if (!n && ew) {
            state = (ComponentState)((Object)state.method_11657((class_2769)CONNECTED_NORTH, Boolean.valueOf(true)));
        }
        if (!s && ew) {
            state = (ComponentState)((Object)state.method_11657((class_2769)CONNECTED_SOUTH, Boolean.valueOf(true)));
        }
        return state;
    }

    private ComponentState getDefaultWireState(Circuit circuit, ComponentState state, ComponentPos pos) {
        for (FlatDirection direction : FlatDirection.VALUES) {
            class_2746 connectionProperty = DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction);
            if (((Boolean)state.method_11654((class_2769)connectionProperty)).booleanValue()) continue;
            boolean wireConnection = this.getRenderConnectionType(circuit, pos, direction);
            state = (ComponentState)((Object)state.method_11657((class_2769)connectionProperty, Boolean.valueOf(wireConnection)));
        }
        return state;
    }

    private static boolean isNotConnected(ComponentState state) {
        return (Boolean)state.method_11654((class_2769)CONNECTED_NORTH) == false && (Boolean)state.method_11654((class_2769)CONNECTED_EAST) == false && (Boolean)state.method_11654((class_2769)CONNECTED_SOUTH) == false && (Boolean)state.method_11654((class_2769)CONNECTED_WEST) == false;
    }

    private static boolean isFullyConnected(ComponentState state) {
        return (Boolean)state.method_11654((class_2769)CONNECTED_NORTH) != false && (Boolean)state.method_11654((class_2769)CONNECTED_EAST) != false && (Boolean)state.method_11654((class_2769)CONNECTED_SOUTH) != false && (Boolean)state.method_11654((class_2769)CONNECTED_WEST) != false;
    }

    private boolean getRenderConnectionType(Circuit circuit, ComponentPos pos, FlatDirection direction) {
        ComponentPos blockPos = pos.offset(direction);
        ComponentState blockState = circuit.getComponentState(blockPos);
        return WireComponent.connectsTo(blockState, direction);
    }

    private static boolean connectsTo(ComponentState state, FlatDirection direction) {
        if (state.isOf(Components.WIRE)) {
            return true;
        }
        if (state.isOf(Components.REPEATER)) {
            FlatDirection rotation = (FlatDirection)((Object)state.method_11654((class_2769)FacingComponent.FACING));
            return rotation == direction || rotation.getOpposite() == direction;
        }
        if (state.isOf(Components.OBSERVER)) {
            return direction == state.method_11654((class_2769)FacingComponent.FACING);
        }
        return state.emitsRedstonePower() && direction != null;
    }

    @Override
    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        if (!wiresGivePower) {
            return 0;
        }
        int i = (Integer)state.method_11654((class_2769)POWER);
        if (i == 0) {
            return 0;
        }
        if (((Boolean)this.getPlacementState(circuit, state, pos).method_11654((class_2769)DIRECTION_TO_CONNECTION_PROPERTY.get((Object)direction.getOpposite()))).booleanValue()) {
            return i;
        }
        return 0;
    }

    @Override
    public int increasePower(ComponentState state, FlatDirection side) {
        return (Integer)state.method_11654((class_2769)POWER);
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{CONNECTED_NORTH, CONNECTED_EAST, CONNECTED_SOUTH, CONNECTED_WEST});
        builder.method_11667(new class_2769[]{POWER});
    }
}

