/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.context;

import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8235;
import net.minecraft.class_8710;
import net.replaceitem.integratedcircuit.IntegratedCircuitBlock;
import net.replaceitem.integratedcircuit.IntegratedCircuitBlockEntity;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.context.ServerCircuitContext;
import net.replaceitem.integratedcircuit.network.packet.ComponentUpdateS2CPacket;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class BlockEntityServerCircuitContext
implements ServerCircuitContext {
    private final IntegratedCircuitBlockEntity blockEntity;

    public BlockEntityServerCircuitContext(IntegratedCircuitBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Nullable
    private class_1937 getWorld() {
        return this.blockEntity.method_10997();
    }

    private class_2338 getPos() {
        return this.blockEntity.method_11016();
    }

    @Override
    public class_5819 getRandom() {
        class_1937 world = this.getWorld();
        if (world == null) {
            return class_5819.method_43047();
        }
        return world.method_8409();
    }

    @Override
    public void markDirty() {
        class_1937 world = this.getWorld();
        this.blockEntity.method_5431();
        if (world != null) {
            world.method_8524(this.getPos());
        }
    }

    @Override
    public void setRenderStrength(FlatDirection portSide, int power) {
        this.blockEntity.setRenderSignalStrength(portSide, power);
        this.markDirty();
        class_1937 world = this.getWorld();
        if (world != null) {
            class_2338 pos = this.getPos();
            class_2680 state = world.method_8320(pos);
            world.method_8413(pos, state, state, 2);
        }
    }

    @Override
    public void onComponentUpdate(ComponentPos pos, ComponentState state) {
        Set<class_3222> editors = this.blockEntity.getEditingPlayers();
        ComponentUpdateS2CPacket packet = new ComponentUpdateS2CPacket(pos, state);
        for (class_3222 player : editors) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    @Override
    public void updateExternal(FlatDirection portSide) {
        class_1937 world = this.getWorld();
        if (world == null) {
            return;
        }
        class_2338 pos = this.getPos();
        class_2680 state = world.method_8320(pos);
        class_2350 vanillaDirection = portSide.toVanillaDirection(state);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IntegratedCircuitBlock) {
            IntegratedCircuitBlock integratedCircuitBlock = (IntegratedCircuitBlock)class_22482;
            integratedCircuitBlock.updateTarget(world, pos, vanillaDirection);
        }
    }

    @Override
    public void readExternalPower(FlatDirection direction) {
        class_1937 world = this.getWorld();
        if (world == null) {
            return;
        }
        class_2338 pos = this.getPos();
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IntegratedCircuitBlock) {
            IntegratedCircuitBlock integratedCircuitBlock = (IntegratedCircuitBlock)class_22482;
            if (this.blockEntity.getCircuit() != null) {
                int power = integratedCircuitBlock.getInputPower((class_8235)world, pos, state, direction);
                this.blockEntity.getCircuit().onExternalPowerChanged(direction, power);
            }
        }
    }

    @Override
    public void playSound(@Nullable class_1657 except, class_3414 sound, class_3419 category, float volume, float pitch) {
        if (this.getWorld() != null) {
            for (class_3222 editingPlayer : this.blockEntity.getEditingPlayers()) {
                if (editingPlayer.equals((Object)except)) continue;
                class_243 soundPos = this.getPos().method_46558();
                editingPlayer.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)sound), category, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, volume, pitch, this.getRandom().method_43055()));
            }
        }
    }

    @Override
    public long getTime() {
        class_1937 world = this.getWorld();
        if (world == null) {
            return 0L;
        }
        return world.method_8510();
    }
}

