/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.replaceitem.integratedcircuit.IntegratedCircuitBlock;

public enum FlatDirection implements class_3542
{
    NORTH(0, "north", 0, -1, Axis.Y, class_2350.field_11043),
    EAST(1, "east", 1, 0, Axis.X, class_2350.field_11034),
    SOUTH(2, "south", 0, 1, Axis.Y, class_2350.field_11035),
    WEST(3, "west", -1, 0, Axis.X, class_2350.field_11039);

    private final int index;
    private final String name;
    private final class_2382 offset;
    private final Axis axis;
    private final class_2350 vanillaDirection;
    public static final FlatDirection[] VALUES;
    public static final FlatDirection[] VALUES_X;
    public static final FlatDirection[] VALUES_Y;
    public static final class_9139<ByteBuf, FlatDirection> PACKET_CODEC;

    private FlatDirection(int index, String name, int dx, int dy, Axis axis, class_2350 vanillaDirection) {
        this.index = index;
        this.name = name;
        this.offset = new class_2382(dx, dy, 0);
        this.axis = axis;
        this.vanillaDirection = vanillaDirection;
    }

    public int getIndex() {
        return this.index;
    }

    public class_2382 getOffset() {
        return this.offset;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public FlatDirection rotated(int times) {
        return VALUES[Math.floorMod(this.getIndex() + times, 4)];
    }

    public FlatDirection rotatedCounterclockwise(int times) {
        return this.rotated(-times);
    }

    public FlatDirection getOpposite() {
        return this.rotated(2);
    }

    public class_2350 toVanillaDirection() {
        return this.vanillaDirection;
    }

    public class_2350 toVanillaDirection(class_2350 facing) {
        return this.rotated(FlatDirection.fromVanillaDirection(facing).getIndex()).toVanillaDirection();
    }

    public class_2350 toVanillaDirection(class_2680 circuit) {
        if (circuit.method_28498((class_2769)IntegratedCircuitBlock.field_11177)) {
            return this.toVanillaDirection((class_2350)circuit.method_11654((class_2769)IntegratedCircuitBlock.field_11177));
        }
        return this.toVanillaDirection();
    }

    public static FlatDirection fromVanillaDirection(class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11036 -> null;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }

    public static FlatDirection fromVanillaDirection(class_2350 facing, class_2350 direction) {
        return FlatDirection.fromVanillaDirection(direction).rotatedCounterclockwise(FlatDirection.fromVanillaDirection(facing).getIndex());
    }

    public static FlatDirection fromVanillaDirection(class_2680 circuit, class_2350 direction) {
        if (circuit.method_28498((class_2769)IntegratedCircuitBlock.field_11177)) {
            return FlatDirection.fromVanillaDirection((class_2350)circuit.method_11654((class_2769)IntegratedCircuitBlock.field_11177), direction);
        }
        return FlatDirection.fromVanillaDirection(direction);
    }

    public static FlatDirection[] forAxis(Axis axis) {
        return axis == Axis.X ? VALUES_X : VALUES_Y;
    }

    public String method_15434() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALUES = FlatDirection.values();
        VALUES_X = new FlatDirection[]{EAST, WEST};
        VALUES_Y = new FlatDirection[]{NORTH, SOUTH};
        PACKET_CODEC = class_9135.method_56375(value -> VALUES[value], FlatDirection::getIndex);
    }

    public static enum Axis {
        X,
        Y;

    }
}

