/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup;

import club.athlas.loademup.api.LoadEmUpAPI;
import club.athlas.loademup.api.constant.Environment;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.loader.PluginLoadersManager;
import club.athlas.loademup.api.platform.DefPlatform;
import club.athlas.loademup.api.virustotal.VirusTotal;
import club.athlas.loademup.config.ConfigLoader;
import club.athlas.loademup.config.Messages;
import club.athlas.loademup.config.constant.ConfigKey;
import club.athlas.loademup.integration.ModrinthUpdateChecker;
import club.athlas.loademup.integration.VirusTotalClient;
import club.athlas.loademup.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import club.athlas.loademup.server.commands.LEUMainCommand;
import club.athlas.loademup.server.loader.LoadersManager;
import club.athlas.loademup.server.loader.PaperPluginLoader;
import club.athlas.loademup.server.loader.SpigotPluginLoader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class LoadEmUp
extends JavaPlugin
implements LoadEmUpAPI {
    private final PluginLoadersManager loadersManager = new LoadersManager();
    private final Environment environment = Environment.PRODUCTION;
    private PluginLoader pluginLoader;
    private BukkitAudiences adventure;
    private ConfigLoader configLoader;
    private AtomicReference<VirusTotal> virusTotalIntegration;
    private ModrinthUpdateChecker updateChecker;

    public void onLoad() {
        this.loadersManager.registerPluginLoader(DefPlatform.SPIGOT, new SpigotPluginLoader(this));
        this.loadersManager.registerPluginLoader(DefPlatform.PAPER, new PaperPluginLoader(this));
        this.loadersManager.registerPluginLoader(DefPlatform.PURPUR, new PaperPluginLoader(this));
    }

    public void onEnable() {
        this.pluginLoader = this.loadersManager.findBestLoader();
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.configLoader = new ConfigLoader(this).load();
        this.virusTotalIntegration = this.initVirusTotalClient();
        this.updateChecker = new ModrinthUpdateChecker((Plugin)this, "loademup");
        if (this.pluginLoader == null) {
            this.getLogger().severe("No plugin loader found!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Initialized Plugin Loader for the " + DefPlatform.getCurrentPlatform().getIdentifier() + " platform.");
        new LEUMainCommand(this).get().register(this);
        this.updateChecker.cacheLatestVersion();
    }

    public void onDisable() {
        this.getVirusTotalIntegration().ifPresent(VirusTotal::shutdown);
    }

    public void reload() {
        this.configLoader.reload();
        this.updateChecker.cacheLatestVersion();
    }

    @Override
    public PluginLoadersManager getLoadersManager() {
        return this.loadersManager;
    }

    @Override
    @NotNull
    public PluginLoader getLoader() {
        return this.pluginLoader;
    }

    @Override
    @NotNull
    public Optional<VirusTotal> getVirusTotalIntegration() {
        return Optional.ofNullable(this.virusTotalIntegration.get());
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    public ConfigLoader getConfigLoader() {
        return this.configLoader;
    }

    public Messages getMessages() {
        return this.configLoader.getMessages();
    }

    @NotNull
    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    public ModrinthUpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @NotNull
    private AtomicReference<VirusTotal> initVirusTotalClient() {
        AtomicReference<Object> clientRef = new AtomicReference<Object>(null);
        if (!this.configLoader.getBool(ConfigKey.VIRUS_SCANNER_ENABLED, false)) {
            return clientRef;
        }
        String apiKey = this.configLoader.getString(ConfigKey.VIRUS_SCANNER_API_KEY, "");
        if (apiKey.isEmpty()) {
            return clientRef;
        }
        VirusTotalClient virusTotalClient = new VirusTotalClient(this, apiKey);
        virusTotalClient.hasValidApiKey().whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().log(Level.WARNING, "Unable to initialize VirusTotalClient.", (Throwable)throwable);
                virusTotalClient.shutdown();
                return;
            }
            if (!result.booleanValue()) {
                this.getLogger().log(Level.WARNING, "The current VirusTotal ApiKey is invalid! Removing VT...");
                virusTotalClient.shutdown();
                return;
            }
            this.getLogger().log(Level.INFO, "Initializing VirusTotalClient...");
            clientRef.set(virusTotalClient);
        });
        return clientRef;
    }
}

