/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.api.object;

import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PluginData(String name, String version, List<String> authors, List<String> contributors, @Nullable String description, @Nullable String website, String apiVersion, boolean paperPlugin) {
    @Contract(value="_ -> new")
    @NotNull
    public static PluginData from(@NotNull PluginDescriptionFile desc) {
        String name = desc.getName();
        String version = desc.getVersion();
        List authors = desc.getAuthors();
        List contributors = desc.getContributors();
        String description = desc.getDescription();
        String website = desc.getWebsite();
        String apiVersion = "Legacy";
        try {
            PluginDescriptionFile.class.getMethod("getAPIVersion", new Class[0]);
            apiVersion = desc.getAPIVersion();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new PluginData(name, version, authors, contributors, description, website, apiVersion, false);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static PluginData from(@NotNull Plugin plugin) {
        return PluginData.from(plugin.getDescription());
    }
}

