/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.api.platform;

import club.athlas.loademup.api.platform.Platform;
import org.jetbrains.annotations.Nullable;

public enum DefPlatform implements Platform
{
    SPIGOT("spigot", null),
    PAPER("paper", "io.papermc.paper.plugin.manager.PaperPluginManagerImpl"),
    PURPUR("purpur", "io.papermc.paper.plugin.manager.PaperPluginManagerImpl");

    private final String identifier;
    private final String classPath;

    private DefPlatform(String identifier, String classPath) {
        this.identifier = identifier;
        this.classPath = classPath;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getFinderClassPath() {
        return this.classPath;
    }

    public static Platform getCurrentPlatform() {
        for (DefPlatform value : DefPlatform.values()) {
            if (value.getFinderClassPath() == null || value.getFinderClassPath().isEmpty()) continue;
            try {
                Class.forName(value.getFinderClassPath());
                return value;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return SPIGOT;
    }
}

