/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.api.utils;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    @Contract(pure=true)
    public static boolean isJarFile(@NotNull File file) {
        return file.getName().toLowerCase().endsWith(".jar");
    }

    public static boolean validateJarIntegrity(File pluginFile) {
        boolean bl;
        JarFile jarFile = new JarFile(pluginFile);
        try {
            jarFile.entries();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    @NotNull
    public static File createFile(String path, boolean replace) {
        File file = new File(path);
        if (file.exists() && !replace) {
            return file;
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    @NotNull
    public static File createFolder(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }
}

