/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.config;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.utils.FileUtils;
import club.athlas.loademup.config.Messages;
import club.athlas.loademup.config.constant.ConfigKey;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConfigLoader {
    private final LoadEmUp plugin;
    private FileConfiguration config;
    private Messages messages;

    public ConfigLoader(LoadEmUp plugin) {
        this.plugin = plugin;
    }

    public ConfigLoader load() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.messages = this.initLang();
        return this;
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.messages = this.initLang();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    private Messages initLang() {
        this.loadDefaultLang();
        String currentLang = this.getString(ConfigKey.LANG_FILE, "EN_us");
        return Messages.initFromFile((Plugin)this.plugin, this.plugin.getAdventure(), "lang/" + currentLang + ".yml");
    }

    private void loadDefaultLang() {
        List<String> availableLang = List.of("EN_us", "IT_it");
        availableLang.forEach(defLang -> {
            String path = "lang/" + defLang + ".yml";
            if (!FileUtils.fileExists(this.plugin.getDataFolder().getAbsolutePath() + "/" + path)) {
                this.plugin.saveResource(path, false);
            }
        });
    }

    public String getString(@NotNull ConfigKey configKey, String defaultValue) {
        String s = this.config.getString(configKey.getPath());
        if (s == null || s.isEmpty()) {
            this.printInvalidValueWarning(configKey, String.valueOf(defaultValue), true);
            return defaultValue;
        }
        return s;
    }

    public boolean getBool(@NotNull ConfigKey configKey, boolean defaultValue) {
        if (!this.config.isSet(configKey.getPath())) {
            this.printInvalidValueWarning(configKey, String.valueOf(defaultValue), true);
            return defaultValue;
        }
        String stringValue = this.config.getString(configKey.getPath());
        if (stringValue == null || !stringValue.equalsIgnoreCase("true") && !stringValue.equalsIgnoreCase("false")) {
            this.printInvalidValueWarning(configKey, String.valueOf(defaultValue), false);
            return defaultValue;
        }
        return this.config.getBoolean(configKey.getPath());
    }

    public long getLong(@NotNull ConfigKey configKey, long defaultValue) {
        if (this.config.get(configKey.getPath()) == null) {
            this.printInvalidValueWarning(configKey, String.valueOf(defaultValue), true);
            return defaultValue;
        }
        try {
            String stringValue = this.config.getString(configKey.getPath());
            if (stringValue == null) {
                this.printInvalidValueWarning(configKey, String.valueOf(defaultValue), true);
                return defaultValue;
            }
            Long.parseLong(stringValue);
            return this.config.getLong(configKey.getPath());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Messages getMessages() {
        return this.messages;
    }

    private void printInvalidValueWarning(@NotNull ConfigKey key, String defaultValue, boolean empty) {
        this.plugin.getLogger().warning("[Config] " + (empty ? "Empty" : "Invalid") + " value found in " + key.getPath() + " in config.yml! Using the default one -> " + defaultValue);
    }
}

