/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.config;

import club.athlas.loademup.config.base.YamlFileHandle;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import club.athlas.loademup.libs.kyori.adventure.text.Component;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.MiniMessage;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Messages {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Configuration langConfig;
    private final BukkitAudiences adventure;
    private final Map<String, String> palette;

    private Messages(Configuration langConfig, BukkitAudiences adventure) {
        this.langConfig = langConfig;
        this.adventure = adventure;
        this.palette = this.initPalette();
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Messages initFromFile(Plugin plugin, BukkitAudiences adventure, @NotNull String filePath) {
        YamlFileHandle customConfig = YamlFileHandle.fromPath(plugin, filePath);
        if (!customConfig.getFile().exists()) {
            plugin.getLogger().log(Level.SEVERE, "[Lang] Couldn't load language! Invalid lang file. Using the default one -> EN_us");
            customConfig = YamlFileHandle.fromResource(plugin, "lang/EN_us.yml");
        }
        plugin.getLogger().log(Level.INFO, "[Lang] Language loaded from file " + customConfig.getFile().getName());
        return new Messages(customConfig.getConfig(), adventure);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public Component getMessage(LangKey langKey, TagResolver ... tagResolver) {
        return this.getPrefix().append(this.getComponent(langKey, tagResolver));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component getMessage(LangKey langKey) {
        return this.getPrefix().append(this.getComponent(langKey, TagResolver.empty()));
    }

    @Contract(value=" -> new")
    @NotNull
    public Component getPrefix() {
        return this.getComponent(LangKey.PREFIX, TagResolver.empty());
    }

    @NotNull
    public Component getComponent(@NotNull LangKey key, TagResolver ... tagResolvers) {
        String rawMessage = this.langConfig.getString(key.getPath(), "");
        TagResolver paletteResolver = TagResolver.resolver((TagResolver[])this.palette.entrySet().stream().map(entry -> Placeholder.parsed((String)entry.getKey(), (String)entry.getValue())).toArray(TagResolver.Single[]::new));
        return this.miniMessage.deserialize(rawMessage, TagResolver.resolver(paletteResolver, TagResolver.resolver(tagResolvers)));
    }

    public void send(CommandSender sender, LangKey key, TagResolver ... resolvers) {
        this.adventure.sender(sender).sendMessage(this.getMessage(key, resolvers));
    }

    public void send(CommandSender sender, LangKey key) {
        this.send(sender, key, TagResolver.empty());
    }

    public boolean isEmpty(@NotNull LangKey key) {
        return this.langConfig.getString(key.getPath(), "").isEmpty();
    }

    @NotNull
    private Map<String, String> initPalette() {
        HashMap<String, String> palette = new HashMap<String, String>();
        ConfigurationSection paletteSection = this.langConfig.getConfigurationSection("vars");
        if (paletteSection == null) {
            return palette;
        }
        paletteSection.getKeys(false).forEach(key -> {
            String serializedComponent = paletteSection.getString(key);
            if (serializedComponent == null) {
                return;
            }
            palette.put(key.toLowerCase(), serializedComponent);
        });
        return palette;
    }
}

