/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.config.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class YamlFileHandle {
    private final File file;
    private FileConfiguration config;

    public YamlFileHandle(File file) {
        this.file = file;
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static YamlFileHandle fromPath(@NotNull Plugin plugin, String path) {
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        File file = new File(plugin.getDataFolder(), path);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new YamlFileHandle(file);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static YamlFileHandle fromResource(@NotNull Plugin plugin, @NotNull String resourcePath, String destinationPath) {
        File outFile;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        if (!(outFile = new File(plugin.getDataFolder(), destinationPath)).exists()) {
            try (InputStream in = plugin.getResource(resourcePath);){
                if (in == null) {
                    throw new IllegalArgumentException("Resource not found: " + resourcePath);
                }
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = in.read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, length);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save resource to file: " + destinationPath, e);
            }
        }
        return new YamlFileHandle(outFile);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static YamlFileHandle fromResource(@NotNull Plugin plugin, @NotNull String path) {
        return YamlFileHandle.fromResource(plugin, path, path);
    }

    public YamlFileHandle createEmptySections(String ... paths) {
        for (String path : paths) {
            if (this.config.isConfigurationSection(path)) continue;
            this.config.createSection(path);
        }
        this.save();
        return this;
    }

    @NotNull
    public ConfigurationSection getSection(@NotNull String path) {
        ConfigurationSection section = this.config.getConfigurationSection(path);
        if (section == null) {
            return this.config.createSection(path);
        }
        return section;
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }
}

