/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.integration;

import club.athlas.loademup.libs.gson.gson.Gson;
import club.athlas.loademup.libs.gson.gson.GsonBuilder;
import club.athlas.loademup.libs.gson.gson.JsonArray;
import club.athlas.loademup.libs.gson.gson.JsonElement;
import club.athlas.loademup.libs.gson.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ModrinthUpdateChecker {
    private final Plugin plugin;
    private final String slug;
    private String latestCachedVersion;

    public ModrinthUpdateChecker(Plugin plugin, String slug) {
        this.plugin = plugin;
        this.slug = slug;
    }

    public void getVersion(BiConsumer<String, Boolean> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            Gson gson = new GsonBuilder().create();
            try {
                URI url = new URI("https://api.modrinth.com/v2/project/" + this.slug + "/version");
                HttpURLConnection connection = (HttpURLConnection)url.toURL().openConnection();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                JsonElement jsonElement = gson.fromJson((Reader)reader, JsonElement.class);
                if (jsonElement == null) {
                    consumer.accept(null, false);
                    return;
                }
                JsonArray json = jsonElement.getAsJsonArray();
                reader.close();
                connection.disconnect();
                JsonObject latest = json.get(0).getAsJsonObject();
                String version = latest.get("version_number").getAsString();
                consumer.accept(version, true);
                this.latestCachedVersion = version;
            }
            catch (FileNotFoundException ignored) {
                consumer.accept("0.0.0", false);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void isLatest(BiConsumer<Boolean, String> consumer) {
        this.getVersion((latestVersion, status) -> consumer.accept(this.getCurrentVersion().equals(latestVersion), (String)latestVersion));
    }

    public void cacheLatestVersion(BiConsumer<String, Boolean> consumer) {
        this.getVersion((latest, status) -> {
            if (status.booleanValue()) {
                this.latestCachedVersion = latest;
            }
            consumer.accept((String)latest, (Boolean)status);
        });
    }

    public void cacheLatestVersion() {
        this.cacheLatestVersion((s, aBoolean) -> this.plugin.getLogger().info("[Update Checker] Cached latest version of " + this.plugin.getName() + "."));
    }

    public String getCurrentVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String getLatestCachedVersion() {
        return this.latestCachedVersion == null ? "\ud83d\udd04" : this.latestCachedVersion;
    }
}

