/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.integration;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.virustotal.VirusTotal;
import club.athlas.loademup.api.virustotal.model.AVVerdict;
import club.athlas.loademup.api.virustotal.model.VTAnalysisResult;
import club.athlas.loademup.api.virustotal.model.VTUploadResponse;
import club.athlas.loademup.libs.gson.gson.Gson;
import club.athlas.loademup.libs.gson.gson.JsonObject;
import club.athlas.loademup.libs.okhttp3.MediaType;
import club.athlas.loademup.libs.okhttp3.MultipartBody;
import club.athlas.loademup.libs.okhttp3.OkHttpClient;
import club.athlas.loademup.libs.okhttp3.Request;
import club.athlas.loademup.libs.okhttp3.RequestBody;
import club.athlas.loademup.libs.okhttp3.Response;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirusTotalClient
implements VirusTotal {
    private static final ExecutorService executors = Executors.newFixedThreadPool(2);
    private static final Gson gson = new Gson();
    private final OkHttpClient client = new OkHttpClient();
    private final LoadEmUp plugin;
    private final String apiKey;

    public VirusTotalClient(LoadEmUp plugin, String apiKey) {
        this.plugin = plugin;
        this.apiKey = apiKey;
    }

    @Override
    public CompletableFuture<VTUploadResponse> runScan(File file) {
        return CompletableFuture.supplyAsync(() -> {
            RequestBody fileBody = RequestBody.create(file, MediaType.parse("application/octet-stream"));
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), fileBody).build();
            Request request = new Request.Builder().url("https://www.virustotal.com/api/v3/files").post(requestBody).addHeader("x-apikey", this.apiKey).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected response code: " + response.code());
                }
                String json = response.body().string();
                JsonObject jsonObj = gson.fromJson(json, JsonObject.class);
                JsonObject data = jsonObj.getAsJsonObject("data");
                String type = data.get("type").getAsString();
                String id = data.get("id").getAsString();
                String link = data.getAsJsonObject("links").get("self").getAsString();
                VTUploadResponse vTUploadResponse = new VTUploadResponse(type, id, link);
                if (response != null) {
                    response.close();
                }
                return vTUploadResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("VirusTotal scan failed", e);
                }
            }
        }, executors);
    }

    @Override
    public CompletableFuture<VTAnalysisResult> getAnalysisResult(String analysisId) {
        return CompletableFuture.supplyAsync(() -> {
            String url = "https://www.virustotal.com/api/v3/analyses/" + analysisId;
            Request request = new Request.Builder().url(url).get().addHeader("x-apikey", this.apiKey).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected response code: " + response.code());
                }
                String json = response.body().string();
                JsonObject root = gson.fromJson(json, JsonObject.class);
                JsonObject attributes = root.getAsJsonObject("data").getAsJsonObject("attributes");
                String status = attributes.get("status").getAsString();
                ArrayList<VTAnalysisResult.AVResult> avResults = new ArrayList<VTAnalysisResult.AVResult>();
                JsonObject results = attributes.getAsJsonObject("results");
                for (String engine : results.keySet()) {
                    JsonObject res = results.getAsJsonObject(engine);
                    String categoryRaw = res.get("category").getAsString();
                    AVVerdict verdict = AVVerdict.fromString(categoryRaw);
                    String type = res.has("result") && !res.get("result").isJsonNull() ? res.get("result").getAsString() : null;
                    String engineVersion = res.has("engine_version") && !res.get("engine_version").isJsonNull() ? res.get("engine_version").getAsString() : null;
                    String method = res.has("method") && !res.get("method").isJsonNull() ? res.get("method").getAsString() : null;
                    avResults.add(new VTAnalysisResult.AVResult(engine, engineVersion, verdict, type, method));
                }
                VTAnalysisResult vTAnalysisResult = new VTAnalysisResult(status, avResults);
                if (response != null) {
                    response.close();
                }
                return vTAnalysisResult;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to fetch analysis result", e);
                }
            }
        }, executors);
    }

    @Override
    public CompletableFuture<Boolean> hasValidApiKey() {
        return CompletableFuture.supplyAsync(() -> {
            Request request = new Request.Builder().url("https://www.virustotal.com/api/v3/users/me").get().addHeader("x-apikey", this.apiKey).build();
            Response response = this.client.newCall(request).execute();
            try {
                Boolean bl = response.isSuccessful();
                if (response != null) {
                    response.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to check API key validity", e);
                }
            }
        }, executors);
    }

    @Override
    public void shutdown() {
        Logger logger = this.plugin.getLogger();
        this.client.dispatcher().cancelAll();
        this.client.connectionPool().evictAll();
        this.client.dispatcher().executorService().shutdownNow();
        try {
            if (!this.client.dispatcher().executorService().awaitTermination(5L, TimeUnit.SECONDS)) {
                logger.severe("OkHttp executor did not terminate in time.");
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "OkHttp executor did not terminate in time.", e);
        }
        executors.shutdownNow();
        try {
            if (!executors.awaitTermination(5L, TimeUnit.SECONDS)) {
                logger.severe("Custom executor did not terminate in time.");
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Custom executor did not terminate in time.", e);
        }
    }
}

