/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands;

import club.athlas.loademup.libs.commands.CommandMeta;
import club.athlas.loademup.libs.commands.ExecutableCommand;
import club.athlas.loademup.libs.commands.arguments.Argument;
import club.athlas.loademup.libs.commands.exceptions.InvalidSetupException;
import club.athlas.loademup.libs.commands.executors.ConsoleCommandExecutor;
import club.athlas.loademup.libs.commands.executors.GenericCommandExecutor;
import club.athlas.loademup.libs.commands.executors.PlayerCommandExecutor;
import club.athlas.loademup.libs.commands.permissions.PermissionNode;
import club.athlas.loademup.libs.commands.permissions.PlainPermission;
import club.athlas.loademup.libs.commands.utils.ChainableBuilder;
import club.athlas.loademup.libs.commands.utils.RemainingTimeSupplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommandAPICommand<Impl extends AbstractCommandAPICommand<Impl>>
extends ExecutableCommand
implements ChainableBuilder<Impl> {
    private final String name = this.getMeta().getName();
    private final CommandMeta meta = this.getMeta();

    public AbstractCommandAPICommand(@NotNull String name) {
        super(new CommandMeta(name.toLowerCase()));
    }

    public final void register(JavaPlugin plugin) {
        if (!this.meta.getSubCommands().isEmpty() && !this.meta.getOptionalArguments().isEmpty()) {
            throw new InvalidSetupException("There can't be optional arguments in a command with a subcommands");
        }
        plugin.getCommand(this.name.toLowerCase()).setExecutor((CommandExecutor)this);
        plugin.getCommand(this.name.toLowerCase()).setTabCompleter((TabCompleter)this);
    }

    public final Impl withPermissions(PermissionNode ... permissions) {
        this.meta.getPermissionNodes().addAll(Arrays.asList(permissions));
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withPermissions(String ... permissions) {
        for (String permission : permissions) {
            this.meta.getPermissionNodes().add(new PlainPermission(permission));
        }
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withRequirement(Predicate<CommandSender> requirement) {
        this.meta.setExecutionRequirement(requirement);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withCoolDown(long coolDown) {
        this.meta.setCoolDown(coolDown);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl replaceCoolDownMessage(RemainingTimeSupplier message) {
        this.meta.setCoolDownMessage(message);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl canBypassCoolDown(PermissionNode ... permissionNodes) {
        for (PermissionNode permissionNode : permissionNodes) {
            this.meta.addCoolDownBypass(permissionNode);
        }
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withArguments(Argument<?> ... args2) {
        this.meta.getArguments().addAll(Arrays.asList(args2));
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withOptionalArguments(Argument<?> ... args2) {
        this.meta.getOptionalArguments().addAll(Arrays.asList(args2));
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withSubCommands(AbstractCommandAPICommand<?> ... subCommands) {
        for (AbstractCommandAPICommand<?> subCmd : subCommands) {
            subCmd.getMeta().setExecutedAsSubCommand(true, this);
            this.meta.getSubCommands().put(subCmd.name.toLowerCase(), subCmd);
        }
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl withSubCommands(@NotNull Collection<AbstractCommandAPICommand<?>> subCommands) {
        subCommands.forEach(xva$0 -> this.withSubCommands((AbstractCommandAPICommand<?>)xva$0));
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl executesPlayer(PlayerCommandExecutor executor) {
        this.meta.getExecutors().put(executor.getType(), executor);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl executesConsole(ConsoleCommandExecutor executor) {
        this.meta.getExecutors().put(executor.getType(), executor);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }

    public final Impl executes(GenericCommandExecutor executor) {
        this.meta.getExecutors().put(executor.getType(), executor);
        return (Impl)((AbstractCommandAPICommand)this.instance());
    }
}

