/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands;

import club.athlas.loademup.libs.commands.AbstractCommandAPICommand;
import club.athlas.loademup.libs.commands.arguments.Argument;
import club.athlas.loademup.libs.commands.executors.ExecutorType;
import club.athlas.loademup.libs.commands.executors.ICommandExecutor;
import club.athlas.loademup.libs.commands.permissions.PermissionNode;
import club.athlas.loademup.libs.commands.utils.RemainingTimeSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandMeta {
    private final String name;
    private final Map<ExecutorType, ICommandExecutor> executors = new HashMap<ExecutorType, ICommandExecutor>();
    private final List<Argument<?>> arguments = new ArrayList();
    private final List<Argument<?>> optionalArguments = new ArrayList();
    private final List<PermissionNode> permissionNodes = new ArrayList<PermissionNode>();
    private final Map<String, AbstractCommandAPICommand<?>> subCommands = new HashMap();
    private final List<AbstractCommandAPICommand<?>> executedFrom = new ArrayList();
    private final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();
    private final List<PermissionNode> canByPassCoolDown = new ArrayList<PermissionNode>();
    private long coolDown = -1L;
    private RemainingTimeSupplier cooldownMessage = remainingTime -> "\u00a78\u00a7l\u00bb \u00a7cWait " + remainingTime + "s before executing this command!";
    private Predicate<CommandSender> requirement = sender -> true;
    private boolean executedAsSubCommand = false;

    public CommandMeta(String name) {
        this.name = name;
        this.defaultExecutors();
    }

    public String getName() {
        return this.name;
    }

    public Map<ExecutorType, ICommandExecutor> getExecutors() {
        return this.executors;
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public List<Argument<?>> getOptionalArguments() {
        return this.optionalArguments;
    }

    public List<PermissionNode> getPermissionNodes() {
        return this.permissionNodes;
    }

    public Map<String, AbstractCommandAPICommand<?>> getSubCommands() {
        return this.subCommands;
    }

    public boolean isExecutedAsSubCommand() {
        return this.executedAsSubCommand;
    }

    public void setExecutedAsSubCommand(boolean executedAsSubCommand, @NotNull AbstractCommandAPICommand<?> executedFrom) {
        this.executedAsSubCommand = executedAsSubCommand;
        if (executedFrom.getMeta().isExecutedAsSubCommand()) {
            this.executedFrom.addAll(executedFrom.getMeta().getExecutedFrom());
        }
        this.executedFrom.add(executedFrom);
    }

    public List<AbstractCommandAPICommand<?>> getExecutedFrom() {
        return this.executedFrom;
    }

    public String getArgumentsString() {
        if (!this.hasArguments()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.getArguments().forEach(argument -> {
            stringBuilder.append("<").append(argument.getName()).append(">");
            if (this.getArguments().indexOf(argument) != this.getArguments().size() - 1) {
                stringBuilder.append(" ");
            }
        });
        this.getOptionalArguments().forEach(argument -> {
            if (!this.getArguments().isEmpty()) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("[<").append(argument.getName()).append(">]");
            if (this.getOptionalArguments().indexOf(argument) != this.getOptionalArguments().size() - 1) {
                stringBuilder.append(" ");
            }
        });
        return stringBuilder.toString();
    }

    public boolean hasArguments() {
        return !this.arguments.isEmpty() || !this.optionalArguments.isEmpty();
    }

    public boolean hasExecutor(ExecutorType executorType) {
        return this.executors.containsKey((Object)executorType);
    }

    public void setExecutionRequirement(Predicate<CommandSender> requirement) {
        this.requirement = requirement;
    }

    public long getCoolDown() {
        return this.coolDown;
    }

    public void setCoolDown(long coolDown) {
        this.coolDown = coolDown;
    }

    public void addCoolDownBypass(PermissionNode permissionNode) {
        this.canByPassCoolDown.add(permissionNode);
    }

    public void setCoolDownMessage(RemainingTimeSupplier message) {
        this.cooldownMessage = message;
    }

    public String getCoolDownMessage(long remainingTime) {
        return this.cooldownMessage.get(remainingTime);
    }

    public long coolDownCheck(@NotNull Player player) {
        if (this.canByPassCoolDown.stream().anyMatch(permissionNode -> permissionNode.has((CommandSender)player))) {
            return -1L;
        }
        long currentMills = System.currentTimeMillis();
        Long coolDownMillis = this.cooldownMap.get(player.getUniqueId());
        if (coolDownMillis == null) {
            this.cooldownMap.put(player.getUniqueId(), currentMills + this.coolDown * 1000L);
            return -1L;
        }
        if (currentMills < coolDownMillis) {
            return (coolDownMillis - currentMills) / 1000L;
        }
        this.cooldownMap.put(player.getUniqueId(), currentMills + this.coolDown * 1000L);
        return -1L;
    }

    public boolean hasSufficientPermissions(@NotNull CommandSender sender) {
        if (sender.isOp() || sender.hasPermission("*")) {
            return true;
        }
        if (this.permissionNodes.isEmpty()) {
            return true;
        }
        return this.permissionNodes.stream().anyMatch(permissionNode -> permissionNode.has(sender));
    }

    public boolean canExecute(CommandSender sender) {
        return this.requirement.test(sender);
    }

    private void defaultExecutors() {
        if (this.executors.containsKey((Object)ExecutorType.PLAYER) && !this.executors.containsKey((Object)ExecutorType.CONSOLE)) {
            this.executors.put(ExecutorType.CONSOLE, (console, args2) -> console.sendMessage("\u00a7cThis commands can't be executed from the console, only players can execute this command!"));
        }
        if (this.executors.containsKey((Object)ExecutorType.CONSOLE) && !this.executors.containsKey((Object)ExecutorType.PLAYER)) {
            this.executors.put(ExecutorType.PLAYER, (player, args2) -> player.sendMessage("\u00a7cThis commands can't be executed by a player, only the console can execute this command!"));
        }
        if (this.executors.isEmpty()) {
            this.executors.put(ExecutorType.GENERIC, (sender, args2) -> sender.sendMessage("\u00a7cThis commands doesn't have any set executor!"));
        }
    }
}

