/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands;

import club.athlas.loademup.libs.commands.AbstractCommandAPICommand;
import club.athlas.loademup.libs.commands.CommandMeta;
import club.athlas.loademup.libs.commands.arguments.Argument;
import club.athlas.loademup.libs.commands.arguments.CommandArguments;
import club.athlas.loademup.libs.commands.executors.ConsoleCommandExecutor;
import club.athlas.loademup.libs.commands.executors.ExecutorType;
import club.athlas.loademup.libs.commands.executors.GenericCommandExecutor;
import club.athlas.loademup.libs.commands.executors.PlayerCommandExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public abstract class ExecutableCommand
implements CommandExecutor,
TabCompleter {
    private final CommandMeta meta;

    public ExecutableCommand(CommandMeta meta) {
        this.meta = meta;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        StringBuilder commandWithArgumentsString = new StringBuilder();
        if (sender instanceof Player && !this.meta.hasSufficientPermissions(sender)) {
            sender.sendMessage("\u00a78\u00a7l\u00bb \u00a7c\u00a7lNon disponi dei permessi neccessari per poter utilizzare questo comando!");
            return false;
        }
        if (!this.meta.canExecute(sender)) {
            return false;
        }
        if (this.meta.isExecutedAsSubCommand()) {
            commandWithArgumentsString.append("\u00a78\u00a7l\u00bb \u00a7f/" + this.meta.getExecutedFrom().get(0).getMeta().getName());
            this.meta.getExecutedFrom().forEach(executedFromCommand -> {
                if (this.meta.getExecutedFrom().indexOf(executedFromCommand) <= 0) {
                    return;
                }
                commandWithArgumentsString.append(executedFromCommand.getMeta().getName());
                if (executedFromCommand.getMeta().hasArguments()) {
                    commandWithArgumentsString.append(" \u00a77" + executedFromCommand.getMeta().getArgumentsString());
                }
            });
            commandWithArgumentsString.append(" \u00a7f" + this.meta.getName());
            if (this.meta.hasArguments()) {
                commandWithArgumentsString.append(" \u00a77" + this.meta.getArgumentsString());
            }
        } else {
            commandWithArgumentsString.append("\u00a78\u00a7l\u00bb \u00a7f/" + this.meta.getName() + " \u00a77" + this.meta.getArgumentsString());
        }
        if (args2.length < this.meta.getArguments().size()) {
            int missingArgIndex = this.meta.getArguments().size() - args2.length - 1;
            sender.sendMessage("");
            sender.sendMessage("\u00a78\u00a7l\u00bb \u00a7c\u00a7lCorrect command usage");
            sender.sendMessage(commandWithArgumentsString.toString());
            sender.sendMessage("");
            return false;
        }
        for (int i = 0; i <= args2.length - 1; ++i) {
            Argument<?> argument;
            String rawArgumentValue = args2[i].toLowerCase();
            if (i > this.meta.getOptionalArguments().size() + (this.meta.getArguments().size() - 1) || this.meta.getArguments().isEmpty() && this.meta.getOptionalArguments().isEmpty() && i == 0) {
                AbstractCommandAPICommand<?> subCommand;
                if (!this.meta.getSubCommands().containsKey(rawArgumentValue.toLowerCase()) || !(subCommand = this.meta.getSubCommands().get(rawArgumentValue)).getMeta().canExecute(sender) || !subCommand.getMeta().hasSufficientPermissions(sender)) break;
                ArrayList<String> subcommandArgs = new ArrayList<String>(Arrays.asList(args2));
                subcommandArgs.subList(0, i + 1).clear();
                String[] subcommandArgsArray = new String[subcommandArgs.size()];
                subcommandArgs.toArray(subcommandArgsArray);
                return this.meta.getSubCommands().get(rawArgumentValue).onCommand(sender, command, label, subcommandArgsArray);
            }
            if (i <= this.meta.getArguments().size() - 1) {
                argument = this.meta.getArguments().get(i);
            } else {
                if (this.meta.getOptionalArguments().isEmpty() || i <= this.meta.getArguments().size() - 1) break;
                argument = this.meta.getOptionalArguments().get(i - this.meta.getArguments().size());
            }
            if (!argument.canExecute(sender) || !argument.hasSufficientPermissions(sender)) break;
            if (argument.validate(rawArgumentValue)) continue;
            sender.sendMessage("");
            sender.sendMessage("\u00a78\u00a7l\u00bb \u00a7c" + argument.errorMessage(rawArgumentValue));
            sender.sendMessage("\u00a78\u00a7l\u00bb \u00a7c\u00a7lCorrect command usage");
            sender.sendMessage(commandWithArgumentsString.toString());
            sender.sendMessage("");
            return false;
        }
        CommandArguments commandArguments = new CommandArguments(this.meta.getArguments(), this.meta.getOptionalArguments(), args2);
        this.meta.getExecutors().values().forEach(typedExecutor -> {
            switch (typedExecutor.getType()) {
                case CONSOLE: {
                    if (!(sender instanceof ConsoleCommandSender)) {
                        return;
                    }
                    ConsoleCommandExecutor consoleExec = (ConsoleCommandExecutor)typedExecutor;
                    consoleExec.run((ConsoleCommandSender)sender, commandArguments);
                    break;
                }
                case PLAYER: {
                    if (!(sender instanceof Player)) {
                        return;
                    }
                    Player player = (Player)sender;
                    if (this.meta.getCoolDown() != -1L && this.meta.coolDownCheck(player) != -1L) {
                        player.sendMessage("\u00a7r" + this.meta.getCoolDownMessage(this.meta.coolDownCheck(player)));
                        return;
                    }
                    PlayerCommandExecutor playerExec = (PlayerCommandExecutor)typedExecutor;
                    playerExec.run(player, commandArguments);
                    break;
                }
                default: {
                    GenericCommandExecutor genericExec = (GenericCommandExecutor)typedExecutor;
                    if (sender instanceof Player && this.meta.hasExecutor(ExecutorType.PLAYER)) {
                        return;
                    }
                    if (sender instanceof ConsoleCommandSender && this.meta.hasExecutor(ExecutorType.CONSOLE)) {
                        return;
                    }
                    genericExec.run(sender, commandArguments);
                }
            }
        });
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        int argIndex;
        if (!this.meta.canExecute(sender) || !this.meta.hasSufficientPermissions(sender)) {
            return Collections.emptyList();
        }
        int n = argIndex = args2.length == 0 ? 0 : args2.length - 1;
        if (args2.length <= this.meta.getArguments().size()) {
            Argument<?> argument = this.meta.getArguments().get(argIndex);
            if (!argument.canExecute(sender) || !argument.hasSufficientPermissions(sender)) {
                return Collections.emptyList();
            }
            return argument.getSuggestions(sender).stream().filter(s -> s.toLowerCase().startsWith(args2[args2.length - 1].toLowerCase())).collect(Collectors.toList());
        }
        if (args2.length - this.meta.getArguments().size() <= this.meta.getOptionalArguments().size()) {
            Argument<?> optionalArgument = this.meta.getOptionalArguments().get(argIndex - this.meta.getArguments().size());
            if (!optionalArgument.canExecute(sender) || !optionalArgument.hasSufficientPermissions(sender)) {
                return Collections.emptyList();
            }
            return optionalArgument.getSuggestions(sender).stream().filter(s -> s.toLowerCase().startsWith(args2[args2.length - 1].toLowerCase())).collect(Collectors.toList());
        }
        if (args2.length > this.meta.getArguments().size() + this.meta.getOptionalArguments().size() && !this.meta.getSubCommands().isEmpty()) {
            List subcommands = this.meta.getSubCommands().values().stream().filter(abstractCommandAPICommand -> abstractCommandAPICommand.getMeta().canExecute(sender) && abstractCommandAPICommand.getMeta().hasSufficientPermissions(sender)).map(abstractCommandAPICommand -> abstractCommandAPICommand.getMeta().getName()).collect(Collectors.toList());
            int lastSubCommandCompleterIndex = 0;
            for (int i = args2.length - 1; i >= 0; --i) {
                if (!this.meta.getSubCommands().containsKey(args2[i])) continue;
                lastSubCommandCompleterIndex = i;
                break;
            }
            if (this.meta.getSubCommands().containsKey(args2[lastSubCommandCompleterIndex].toLowerCase())) {
                String currentSubCommand = args2[lastSubCommandCompleterIndex].toLowerCase();
                ArrayList<String> subcommandArgs = new ArrayList<String>(Arrays.asList(args2));
                subcommandArgs.subList(0, lastSubCommandCompleterIndex + 1).clear();
                String[] subcommandArgsArray = new String[subcommandArgs.size()];
                subcommandArgs.toArray(subcommandArgsArray);
                if (args2[args2.length - 1].equalsIgnoreCase(args2[lastSubCommandCompleterIndex])) {
                    return subcommandArgs;
                }
                return this.meta.getSubCommands().get(currentSubCommand).onTabComplete(sender, command, alias, subcommandArgsArray);
            }
            return subcommands.stream().filter(s -> s.toLowerCase().startsWith(args2[args2.length - 1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public CommandMeta getMeta() {
        return this.meta;
    }
}

