/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands.arguments;

import club.athlas.loademup.libs.commands.framework.utils.StringSupplier;
import club.athlas.loademup.libs.commands.framework.utils.SuggestionSupplier;
import club.athlas.loademup.libs.commands.permissions.PermissionNode;
import club.athlas.loademup.libs.commands.permissions.PlainPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class Argument<T> {
    private final String name;
    private final List<PermissionNode> permissionNodes = new ArrayList<PermissionNode>();
    private SuggestionSupplier suggestionSupplier = sender -> Collections.emptyList();
    private Predicate<CommandSender> requirement = unused -> true;
    private StringSupplier errorMessage = string -> "Invalid Argument Value!";

    public Argument(String name) {
        this.name = name;
    }

    public abstract boolean validate(String var1);

    public abstract T parse(String[] var1, int var2);

    public final String getName() {
        return this.name;
    }

    public final Argument<T> replaceSuggestions(SuggestionSupplier suggestion) {
        this.suggestionSupplier = suggestion;
        return this;
    }

    @Contract(value="_ -> new")
    @NotNull
    public final List<String> getSuggestions(CommandSender sender) {
        return new ArrayList<String>(this.suggestionSupplier.get(sender));
    }

    public final Argument<T> replaceErrorMessage(StringSupplier message) {
        this.errorMessage = message;
        return this;
    }

    public final String errorMessage(String insertedValue) {
        return this.errorMessage.get(insertedValue);
    }

    public final Argument<T> withPermissions(PermissionNode ... permissions) {
        this.permissionNodes.addAll(Arrays.asList(permissions));
        return this;
    }

    @Contract(value="_ -> this")
    public final Argument<T> withPermissions(String ... permissions) {
        for (String permission : permissions) {
            this.permissionNodes.add(new PlainPermission(permission));
        }
        return this;
    }

    public final Argument<T> withRequirement(Predicate<CommandSender> requirement) {
        this.requirement = requirement;
        return this;
    }

    public boolean hasSufficientPermissions(@NotNull CommandSender sender) {
        if (sender.isOp() || sender.hasPermission("*")) {
            return true;
        }
        if (this.permissionNodes.isEmpty()) {
            return true;
        }
        return this.permissionNodes.stream().anyMatch(permissionNode -> permissionNode.has((CommandSender)((Player)sender)));
    }

    public boolean canExecute(CommandSender sender) {
        return this.requirement.test(sender);
    }
}

