/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands.arguments;

import club.athlas.loademup.libs.commands.arguments.Argument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class CommandArguments {
    private final Map<String, Object> parsedArgs = new HashMap<String, Object>();
    private final String[] rawArgs;

    public CommandArguments(@NotNull List<Argument<?>> arguments, List<Argument<?>> optionalArguments, String[] cmdArgs) {
        int argToParseIndex;
        int i;
        this.rawArgs = cmdArgs;
        for (i = 0; i <= arguments.size() - 1 && cmdArgs.length - 1 >= i; ++i) {
            Argument<?> argument = arguments.get(i);
            this.parsedArgs.put(argument.getName(), argument.parse(cmdArgs, i));
        }
        for (i = 0; i <= optionalArguments.size() - 1 && cmdArgs.length - 1 >= (argToParseIndex = this.parsedArgs.size() + i); ++i) {
            Argument<?> argument = optionalArguments.get(i);
            this.parsedArgs.put(argument.getName(), argument.parse(cmdArgs, argToParseIndex));
        }
    }

    public Object get(int index) {
        return this.parsedArgs.values().toArray()[index];
    }

    public Object get(@NotNull String name) {
        return this.parsedArgs.get(name.toLowerCase());
    }

    public Optional<Object> getOptional(int index) {
        return Optional.ofNullable(this.parsedArgs.values().toArray()[index]);
    }

    public Optional<Object> getOptional(@NotNull String name) {
        return Optional.ofNullable(this.parsedArgs.get(name.toLowerCase()));
    }

    public Map<String, Object> getArgs() {
        return this.parsedArgs;
    }

    public String[] getRawArgs() {
        return this.rawArgs;
    }
}

