/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands.arguments;

import club.athlas.loademup.libs.commands.arguments.Argument;

public class FloatArgument
extends Argument<Float> {
    public FloatArgument(String name) {
        super(name);
        this.replaceErrorMessage(insertedValue -> this.getName() + " has to be a floating value!");
    }

    @Override
    public boolean validate(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Float parse(String[] args2, int currentIndex) {
        return Float.valueOf(Float.parseFloat(args2[currentIndex]));
    }
}

