/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.commands.utility.helpers;

import club.athlas.loademup.libs.commands.arguments.CommandArguments;
import club.athlas.loademup.libs.commands.executors.GenericCommandExecutor;
import club.athlas.loademup.libs.commands.usable.CommandAPI;
import club.athlas.loademup.libs.commands.utility.CommandSupplier;
import club.athlas.loademup.libs.commands.utility.helpers.HelpValue;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;

public class HelpExecutor
implements GenericCommandExecutor {
    private final CommandSupplier commandSupplier;

    public HelpExecutor(CommandSupplier commandSupplier) {
        this.commandSupplier = commandSupplier;
    }

    @Override
    public void run(CommandSender sender, CommandArguments args2) {
        List<HelpValue> helpValues = this.commandSupplier.getHelp().stream().filter(helpValue -> {
            if (helpValue.getPermission() == null || helpValue.getPermission().has(sender)) {
                return true;
            }
            return helpValue.getPermission() != null && helpValue.getPermission().has(sender);
        }).collect(Collectors.toList());
        ComponentBuilder componentBuilder = new ComponentBuilder("\n\u00a78\u00a7l\u00bb \u00a73\u00a7lComandi disponibili \u00a78( \u00a7b/" + this.commandSupplier.getName() + " \u00a78)\n");
        if (helpValues.isEmpty()) {
            componentBuilder.append("\u00a78\u00a7l\u00bb \u00a77\u00a7oNon ci sono comandi disponibili :(\n");
        } else {
            componentBuilder.append("\n");
            helpValues.forEach(helpValue -> {
                componentBuilder.append("\u00a78\u00a7l\u00bb \u00a7b/" + this.commandSupplier.getName());
                StringBuilder suggestion = new StringBuilder("/" + this.commandSupplier.getName());
                if (((CommandAPI)this.commandSupplier.get()).getMeta().hasArguments()) {
                    componentBuilder.append(" \u00a7f" + ((CommandAPI)this.commandSupplier.get()).getMeta().getArgumentsString());
                    suggestion.append(" ").append(((CommandAPI)this.commandSupplier.get()).getMeta().getArgumentsString());
                }
                componentBuilder.append(" \u00a7b" + helpValue.getCommand() + " \u00a77" + helpValue.getDescription() + "\n");
                suggestion.append(" ").append(helpValue.getCommand());
                componentBuilder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a78\u00a7l\u00bb\u00a7r \u00a77Click to execute this command")));
                componentBuilder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestion.toString()));
            });
        }
        sender.spigot().sendMessage(componentBuilder.create());
    }
}

