/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.standard;

import club.athlas.loademup.libs.kyori.adventure.key.InvalidKeyException;
import club.athlas.loademup.libs.kyori.adventure.key.Key;
import club.athlas.loademup.libs.kyori.adventure.text.format.Style;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.Context;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.ParsingException;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.Tag;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

final class FontTag {
    static final String FONT = "font";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("font", FontTag::create, StyleClaim.claim("font", Style::font, FontTag::emit));

    private FontTag() {
    }

    static Tag create(ArgumentQueue args2, Context ctx) throws ParsingException {
        Key font;
        String valueOrNamespace = args2.popOr("A font tag must have either arguments of either <value> or <namespace:value>").value();
        try {
            if (!args2.hasNext()) {
                font = Key.key(valueOrNamespace);
            } else {
                String fontKey = args2.pop().value();
                font = Key.key(valueOrNamespace, fontKey);
            }
        }
        catch (InvalidKeyException ex) {
            throw ctx.newException(ex.getMessage(), args2);
        }
        return Tag.styling(builder -> builder.font(font));
    }

    static void emit(Key font, TokenEmitter emitter) {
        emitter.tag(FONT);
        if (font.namespace().equals("minecraft")) {
            emitter.argument(font.value());
        } else {
            emitter.arguments(font.namespace(), font.value());
        }
    }
}

