/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.constant.LEUAction;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.object.PluginData;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.commands.arguments.StringArgument;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import club.athlas.loademup.server.commands.CommandCommons;
import club.athlas.loademup.utils.TagResolverUtils;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;

public class EnableCommand
extends SubCommand<LoadEmUp> {
    private final PluginLoader loader;

    public EnableCommand(LoadEmUp plugin) {
        super(plugin, "enable");
        this.loader = plugin.getLoader();
    }

    @Override
    public void setup() {
        this.withPermissions("loademup.command.enable");
        this.withArguments(new StringArgument("plugin").replaceSuggestions(commandSender -> this.loader.getPlugins().stream().map(Plugin::getName).collect(Collectors.toList())));
        this.executes((sender, args2) -> {
            String pluginName = (String)args2.get("plugin");
            sender.sendMessage("\n");
            this.loader.getPlugin(pluginName).ifPresentOrElse(targetPlugin -> {
                if (!CommandCommons.sendUnsupportedAction((LoadEmUp)this.plugin, LEUAction.LOAD, targetPlugin, sender)) {
                    return;
                }
                TagResolver placeholder = TagResolverUtils.resolverFrom(PluginData.from(targetPlugin));
                if (targetPlugin.isEnabled()) {
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_ALREADY_ENABLED, placeholder);
                    return;
                }
                try {
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_ENABLE_START, placeholder);
                    long start = System.currentTimeMillis();
                    this.loader.enablePlugin((Plugin)targetPlugin);
                    long end = System.currentTimeMillis() - start;
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_ENABLED, placeholder, TagResolverUtils.resolverFromTime(end));
                }
                catch (Exception e) {
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_ENABLE_FAIL, Placeholder.parsed("error_msg", e.getMessage()));
                    ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "Failed to enable plugin " + targetPlugin.getName(), e);
                }
            }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_NOT_FOUND, Placeholder.parsed("name", pluginName)));
            sender.sendMessage("\n");
        });
    }
}

