/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.config.Messages;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.commands.permissions.StartsWithPermission;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.commands.utility.helpers.HelpValue;
import club.athlas.loademup.libs.kyori.adventure.text.Component;
import club.athlas.loademup.libs.kyori.adventure.text.TextComponent;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import club.athlas.loademup.utils.BasicFunctions;
import club.athlas.loademup.utils.TagResolverUtils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class HelpCommand
extends SubCommand<LoadEmUp> {
    private final Messages messages;

    public HelpCommand(LoadEmUp plugin) {
        super(plugin, "help");
        this.messages = plugin.getMessages();
    }

    @Override
    public void setup() {
        this.executes((sender, args2) -> {
            Component helpMessage = this.getHelpMessage(sender);
            ((LoadEmUp)this.plugin).getAdventure().sender(sender).sendMessage(helpMessage);
        });
    }

    @Contract(value=" -> new")
    @NotNull
    private @Unmodifiable List<HelpValue> getHelpValues() {
        return List.of(new HelpValue("loademup help", "View this message", new StartsWithPermission("loademup.command.")), new HelpValue("loademup load <plugin>", "Load a new plugin.", "loademup.command.load"), new HelpValue("loademup unload <plugin> [flags]", "Unload a plugin.", "loademup.command.unload"), new HelpValue("loademup reload <plugin> [flags]", "Reload a plugin.", "loademup.command.reload"), new HelpValue("loademup enable <plugin>", "Enable a plugin", "loademup.command.enable"), new HelpValue("loademup enable <plugin>", "Disable a plugin", "loademup.command.disable"), new HelpValue("loademup scan <plugin>", "Disable a plugin", "loademup.command.scan"), new HelpValue("loademup info <plugin>", "Get a plugin info.", "loademup.command.info"));
    }

    @NotNull
    private Component getHelpMessage(CommandSender sender) {
        TagResolver[] commonPlaceholders = new TagResolver.Single[]{Placeholder.component("build", BasicFunctions.getUpdateCheckerComponent(((LoadEmUp)this.plugin).getUpdateChecker())), Placeholder.parsed("version", ((LoadEmUp)this.plugin).getDescription().getVersion()), Placeholder.parsed("latest", ((LoadEmUp)this.plugin).getUpdateChecker().getLatestCachedVersion())};
        TextComponent.Builder builder = Component.text();
        if (!this.messages.isEmpty(LangKey.HELP_MESSAGE_HEADER)) {
            builder.append(this.messages.getComponent(LangKey.HELP_MESSAGE_HEADER, commonPlaceholders));
        }
        if (!this.messages.isEmpty(LangKey.HELP_MESSAGE_COMMAND_FORMAT)) {
            List<HelpValue> visibleHelpValues = this.getHelpValues().stream().filter(helpValue -> helpValue.getPermission().has(sender) || sender.hasPermission("loademup.*")).toList();
            for (int i = 0; i < visibleHelpValues.size(); ++i) {
                HelpValue helpValue2 = visibleHelpValues.get(i);
                builder.append(this.messages.getComponent(LangKey.HELP_MESSAGE_COMMAND_FORMAT, TagResolverUtils.resolverFrom(helpValue2)));
                if (i >= visibleHelpValues.size() - 1) continue;
                builder.appendNewline();
            }
        }
        if (!this.messages.isEmpty(LangKey.HELP_MESSAGE_FOOTER)) {
            builder.append(this.messages.getComponent(LangKey.HELP_MESSAGE_FOOTER, commonPlaceholders));
        }
        return builder.build();
    }
}

