/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.object.Dependency;
import club.athlas.loademup.api.object.PluginData;
import club.athlas.loademup.libs.commands.arguments.StringArgument;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.kyori.adventure.text.Component;
import club.athlas.loademup.libs.kyori.adventure.text.TextComponent;
import club.athlas.loademup.libs.kyori.adventure.text.format.NamedTextColor;
import club.athlas.loademup.libs.kyori.adventure.text.format.TextColor;
import club.athlas.loademup.libs.kyori.adventure.text.format.TextDecoration;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InfoCommand
extends SubCommand<LoadEmUp> {
    private final PluginLoader loader;

    public InfoCommand(LoadEmUp plugin) {
        super(plugin, "info");
        this.loader = plugin.getLoader();
    }

    @Override
    public void setup() {
        this.withArguments(new StringArgument("plugin").replaceSuggestions(commandSender -> this.loader.getPlugins().stream().map(Plugin::getName).collect(Collectors.toList())));
        this.executes((sender, args2) -> {
            this.withPermissions("loademup.command.info");
            String pluginName = (String)args2.get("plugin");
            this.loader.getPlugin(pluginName).ifPresentOrElse(pl -> {
                PluginData data = PluginData.from(pl);
                @NotNull TextComponent.Builder component = Component.text();
                component.appendNewline();
                component.append(Component.text(" " + data.name(), (TextColor)NamedTextColor.YELLOW, TextDecoration.BOLD), Component.text(" v" + data.version().replace("v", ""), (TextColor)NamedTextColor.GRAY), Component.text(" - ", (TextColor)NamedTextColor.DARK_GRAY), Component.text(pl.isEnabled() ? "Enabled" : "Disabled", (TextColor)(pl.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED), TextDecoration.BOLD));
                ((TextComponent.Builder)component.appendNewline()).appendNewline();
                if (!data.authors().isEmpty()) {
                    component.append(Component.text("    Author(s) ", (TextColor)NamedTextColor.YELLOW), Component.text(data.authors().toString().replace("[", "").replace("]", "")), Component.newline());
                }
                if (!data.contributors().isEmpty()) {
                    component.append(Component.text("    Contributors ", (TextColor)NamedTextColor.YELLOW), Component.text(data.contributors().toString().replace("[", "").replace("]", "")), Component.newline());
                }
                if (data.description() != null && !data.description().isEmpty()) {
                    component.append(Component.text("    Description ", (TextColor)NamedTextColor.YELLOW), Component.text(data.description()), Component.newline());
                }
                if (data.website() != null && !data.website().isEmpty()) {
                    component.append(Component.text("    Description ", (TextColor)NamedTextColor.YELLOW), Component.text(data.website()), Component.newline());
                }
                component.append(Component.text("    API-Ver ", (TextColor)NamedTextColor.YELLOW), Component.text(data.apiVersion()));
                ((TextComponent.Builder)component.appendNewline()).appendNewline();
                List<Dependency> dependencies = this.loader.getDependencies((Plugin)pl);
                component.append((Component)this.appendDependencyList("Dependencies", this.filterDeps(dependencies, Dependency::required)));
                ((TextComponent.Builder)component.appendNewline()).appendNewline();
                component.append((Component)this.appendDependencyList("Soft-Dependencies", this.filterDeps(dependencies, dependency -> !dependency.required())));
                List<Dependency> dependents = this.loader.getDependents((Plugin)pl);
                ((TextComponent.Builder)component.appendNewline()).appendNewline();
                component.append((Component)this.appendDependencyList("Dependants", this.filterDeps(dependents, Dependency::required)));
                ((TextComponent.Builder)component.appendNewline()).appendNewline();
                component.append((Component)this.appendDependencyList("Soft-Dependants", this.filterDeps(dependents, dependency -> !dependency.required())));
                component.appendNewline();
                ((LoadEmUp)this.plugin).getAdventure().sender(sender).sendMessage(component);
            }, () -> sender.sendMessage("Not found plugin: " + pluginName));
        });
    }

    @NotNull
    private TextComponent appendDependencyList(String title, @NotNull List<Dependency> dependencies) {
        if (dependencies.isEmpty()) {
            return (TextComponent)Component.text("    " + title, (TextColor)NamedTextColor.YELLOW).append(Component.text(" None", (TextColor)NamedTextColor.RED));
        }
        TextComponent.Builder component = Component.text();
        component.append((Component)Component.text("    " + title, (TextColor)NamedTextColor.YELLOW));
        component.appendNewline();
        for (int i = 0; i < dependencies.size(); ++i) {
            Dependency dep = dependencies.get(i);
            boolean enabled = dep.isLoaded();
            NamedTextColor color = enabled ? NamedTextColor.GREEN : NamedTextColor.RED;
            component.append((Component)Component.text("      \u230a ", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD));
            component.append((Component)Component.text(dep.name(), (TextColor)color));
            if (i >= dependencies.size() - 1) continue;
            component.appendNewline();
        }
        return (TextComponent)component.build();
    }

    private List<Dependency> filterDeps(@NotNull Collection<Dependency> dependencies, Predicate<Dependency> predicate) {
        return dependencies.stream().filter(predicate).collect(Collectors.toList());
    }
}

