/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.constant.LEUAction;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.object.PluginData;
import club.athlas.loademup.api.utils.FileUtils;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.commands.arguments.LongStringArgument;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import club.athlas.loademup.server.commands.CommandCommons;
import club.athlas.loademup.utils.TagResolverUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class LoadCommand
extends SubCommand<LoadEmUp> {
    private final PluginLoader loader;

    public LoadCommand(LoadEmUp plugin) {
        super(plugin, "load");
        this.loader = plugin.getLoader();
    }

    @Override
    public void setup() {
        this.withArguments(new LongStringArgument("plugin").replaceSuggestions(commandSender -> this.loader.getPluginJarFiles().stream().map(File::getName).collect(Collectors.toList())));
        this.executes((sender, args2) -> {
            this.withPermissions("loademup.command.load");
            String jarFile = (String)args2.get("plugin");
            sender.sendMessage("\n");
            this.loader.getPluginFile(jarFile).ifPresentOrElse(targetFile -> {
                if (!CommandCommons.sendUnsupportedAction((LoadEmUp)this.plugin, LEUAction.LOAD, targetFile, sender)) {
                    return;
                }
                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.LOOKING_FOR_PLUGIN_YML, Placeholder.parsed("file", targetFile.getName()));
                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.INTEGRITY_CHECK_START, Placeholder.parsed("file", targetFile.getName()));
                if (!FileUtils.validateJarIntegrity(targetFile)) {
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.INVALID_PLUGIN_JAR, Placeholder.parsed("file", targetFile.getName()));
                    return;
                }
                this.loader.getDescriptionFile((File)targetFile).ifPresentOrElse(desc -> {
                    if (!CommandCommons.sendPluginDescValidationResult((LoadEmUp)this.plugin, desc, sender)) {
                        return;
                    }
                    TagResolver placeholder = TagResolverUtils.resolverFrom(PluginData.from(desc));
                    if (this.loader.getPlugin(desc.getName()).isPresent()) {
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_ALREADY_LOADED, placeholder);
                        return;
                    }
                    if (!CommandCommons.sendClassLoaderValidationResult((LoadEmUp)this.plugin, targetFile, sender)) {
                        return;
                    }
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.CHECKING_DEPENDENCIES, placeholder);
                    if (!CommandCommons.sendMissingDepsResult((LoadEmUp)this.plugin, desc, sender)) {
                        return;
                    }
                    try {
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_LOAD_START, placeholder);
                        long start = System.currentTimeMillis();
                        this.loader.load((File)targetFile).ifPresent(loaded -> {
                            long time = System.currentTimeMillis() - start;
                            if (loaded.isEnabled()) {
                                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_LOADED, placeholder, TagResolverUtils.resolverFromTime(time));
                                return;
                            }
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_LOADED_BUT_DISABLED, placeholder, TagResolverUtils.resolverFromTime(time));
                        });
                    }
                    catch (Exception e) {
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_LOAD_FAIL, Placeholder.parsed("error_msg", e.getMessage()));
                        ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "Unable to load plugin " + desc.getName(), e);
                    }
                }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.MISSING_PLUGIN_DESCRIPTION, Placeholder.parsed("file", targetFile.getName())));
            }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.JAR_NOT_FOUND, Placeholder.parsed("file", jarFile)));
            sender.sendMessage("\n");
        });
    }
}

