/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.constant.LEUAction;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.object.Dependency;
import club.athlas.loademup.api.object.PluginData;
import club.athlas.loademup.api.utils.FileUtils;
import club.athlas.loademup.api.utils.LEUUtils;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.commands.arguments.StringArgument;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import club.athlas.loademup.server.commands.CommandCommons;
import club.athlas.loademup.utils.TagResolverUtils;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ReloadCommand
extends SubCommand<LoadEmUp> {
    private final PluginLoader loader;

    public ReloadCommand(LoadEmUp plugin) {
        super(plugin, "reload");
        this.loader = plugin.getLoader();
    }

    @Override
    public void setup() {
        this.withPermissions("loademup.command.reload");
        this.withArguments(new StringArgument("plugin").replaceSuggestions(commandSender -> this.loader.getPlugins().stream().map(Plugin::getName).collect(Collectors.toList())));
        this.executes((sender, args2) -> {
            String pluginName = (String)args2.get("plugin");
            sender.sendMessage("\n");
            this.loader.getPlugin(pluginName).ifPresentOrElse(targetPlugin -> {
                if (!CommandCommons.sendUnsupportedAction((LoadEmUp)this.plugin, LEUAction.RELOAD, targetPlugin, sender)) {
                    return;
                }
                TagResolver pluginDataPlaceholder = TagResolverUtils.resolverFrom(PluginData.from(targetPlugin));
                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.LOOKING_FOR_NEW_JAR_FILE, pluginDataPlaceholder);
                this.loader.getPluginFile((Plugin)targetPlugin).ifPresentOrElse(targetFile -> {
                    if (!targetFile.exists()) {
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.JAR_NOT_FOUND, Placeholder.parsed("file", targetFile.getName()));
                        return;
                    }
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.LOOKING_FOR_PLUGIN_YML, Placeholder.parsed("file", targetFile.getName()));
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.INTEGRITY_CHECK_START, Placeholder.parsed("file", targetFile.getName()));
                    if (!FileUtils.validateJarIntegrity(targetFile)) {
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.INVALID_PLUGIN_JAR, Placeholder.parsed("file", targetFile.getName()));
                        return;
                    }
                    this.loader.getDescriptionFile((File)targetFile).ifPresentOrElse(desc -> {
                        if (!CommandCommons.sendPluginDescValidationResult((LoadEmUp)this.plugin, desc, sender)) {
                            return;
                        }
                        TagResolver updatedPluginDataPlaceholder = TagResolverUtils.resolverFrom(PluginData.from(desc));
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.CHECKING_DEPENDENTS, updatedPluginDataPlaceholder);
                        List<Plugin> dependants = this.getDependentsTopologicalOrder(this.loader, (Plugin)targetPlugin);
                        if (!dependants.isEmpty() && !CommandCommons.hasArgFlags(args2, "--reload-deps", "--force")) {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_RELOAD_BLOCKED, updatedPluginDataPlaceholder, TagResolverUtils.listPlaceholder("dependants", dependants.stream().map(Plugin::getName).collect(Collectors.toList())));
                            return;
                        }
                        if (!CommandCommons.sendClassLoaderValidationResult((LoadEmUp)this.plugin, targetFile, sender)) {
                            return;
                        }
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.CHECKING_DEPENDENCIES, updatedPluginDataPlaceholder);
                        if (!CommandCommons.sendMissingDepsResult((LoadEmUp)this.plugin, desc, sender)) {
                            return;
                        }
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_RELOAD_START, updatedPluginDataPlaceholder);
                        long start = System.currentTimeMillis();
                        try {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_UNLOAD_START, updatedPluginDataPlaceholder);
                            this.loader.unload((Plugin)targetPlugin);
                        }
                        catch (Exception e) {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_RELOAD_FAIL, updatedPluginDataPlaceholder, Placeholder.parsed("error_msg", e.getMessage()));
                            ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "Failed to reload plugin " + targetPlugin.getName(), e);
                        }
                        try {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_LOAD_START, updatedPluginDataPlaceholder);
                            this.loader.load((File)targetFile).ifPresent(loaded -> {
                                long time = System.currentTimeMillis() - start;
                                if (loaded.isEnabled()) {
                                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_RELOADED, updatedPluginDataPlaceholder, TagResolverUtils.resolverFromTime(time));
                                    return;
                                }
                                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_LOADED_BUT_DISABLED, updatedPluginDataPlaceholder, TagResolverUtils.resolverFromTime(time));
                            });
                            if (!CommandCommons.hasArgFlags(args2, "--reload-deps")) {
                                return;
                            }
                            long dependantsReloadStart = System.currentTimeMillis();
                            AtomicInteger successFullyReloadedDeps = new AtomicInteger();
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.RELOADING_DEPENDANDTS, updatedPluginDataPlaceholder, Placeholder.parsed("count", String.valueOf(dependants.size())));
                            dependants.forEach(dependant -> {
                                Optional<File> currentJar = this.loader.getPluginCurrentJarInst((Plugin)dependant);
                                TagResolver dependantPlaceholder = TagResolverUtils.resolverFrom(PluginData.from(dependant), "dependant");
                                if (currentJar.isEmpty()) {
                                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.DEPENDAND_CURRENT_JAR_NOT_FOUND, updatedPluginDataPlaceholder, TagResolverUtils.resolverFrom(PluginData.from(dependant)));
                                    return;
                                }
                                if (!LEUUtils.isSupported(currentJar.get(), LEUAction.RELOAD)) {
                                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.DEPENDAND_RELOAD_UNSUPPORTED, updatedPluginDataPlaceholder, TagResolverUtils.resolverFrom(PluginData.from(dependant)));
                                    return;
                                }
                                long dependantReloadStart = System.currentTimeMillis();
                                try {
                                    this.loader.reloadFromCurrentJar((Plugin)dependant);
                                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_DEPENDANT_RELOADED, updatedPluginDataPlaceholder, dependantPlaceholder, TagResolverUtils.resolverFromTime(System.currentTimeMillis() - dependantReloadStart));
                                    successFullyReloadedDeps.getAndIncrement();
                                }
                                catch (InvalidDescriptionException | InvalidPluginException e) {
                                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_DEPENDANT_RELOAD_FAIL, updatedPluginDataPlaceholder, dependantPlaceholder, Placeholder.parsed("error_msg", e.getMessage()), TagResolverUtils.resolverFromTime(System.currentTimeMillis() - dependantReloadStart));
                                    ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "Failed to reload plugin " + targetPlugin.getName() + " dependant " + dependant.getName(), e);
                                }
                            });
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_DEPENDANTS_RELOAD_FINISH, updatedPluginDataPlaceholder, TagResolverUtils.resolverFromTime(System.currentTimeMillis() - dependantsReloadStart), Placeholder.parsed("count", String.valueOf(dependants.size())));
                        }
                        catch (Exception e) {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_RELOAD_FAIL, updatedPluginDataPlaceholder, Placeholder.parsed("error_msg", e.getMessage()));
                            ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "Failed to reload plugin " + targetPlugin.getName(), e);
                        }
                    }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.MISSING_PLUGIN_DESCRIPTION, Placeholder.parsed("file", targetFile.getName())));
                }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.MISSING_NEW_JAR_FILE, pluginDataPlaceholder));
            }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_NOT_FOUND, Placeholder.parsed("name", pluginName)));
            sender.sendMessage("\n");
        });
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String @NotNull [] args2) {
        if (args2.length <= 1) {
            return super.onTabComplete(sender, command, alias, args2);
        }
        return List.of("--force", "--reload-deps");
    }

    @NotNull
    private List<Plugin> getDependentsTopologicalOrder(PluginLoader loader, Plugin rootPlugin) {
        HashSet<Plugin> allDependents = new HashSet<Plugin>();
        this.collectAllDependents(loader, rootPlugin, allDependents);
        return this.topologicalSort(allDependents);
    }

    private void collectAllDependents(@NotNull PluginLoader loader, Plugin plugin, Set<Plugin> collected) {
        for (Dependency dependant : loader.getDependents(plugin)) {
            if (!dependant.isLoaded()) continue;
            dependant.getPlugin().ifPresent(depPlugin -> {
                if (collected.add((Plugin)depPlugin)) {
                    this.collectAllDependents(loader, (Plugin)depPlugin, collected);
                }
            });
        }
    }

    @NotNull
    private List<Plugin> topologicalSort(@NotNull Set<Plugin> plugins) {
        Map<String, Plugin> nameToPlugin = plugins.stream().collect(Collectors.toMap(Plugin::getName, p -> p));
        HashMap adj = new HashMap();
        for (Plugin plugin : plugins) {
            adj.put(plugin.getName(), new ArrayList());
        }
        for (Plugin plugin : plugins) {
            List<String> dependencies = this.getDirectDependencyNames(plugin);
            for (String depName : dependencies) {
                if (!adj.containsKey(depName)) continue;
                ((List)adj.get(depName)).add(plugin.getName());
            }
        }
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        for (String name : adj.keySet()) {
            inDegree.put(name, 0);
        }
        for (Object deps : adj.values()) {
            Iterator iterator2 = deps.iterator();
            while (iterator2.hasNext()) {
                String to = (String)iterator2.next();
                inDegree.put(to, (Integer)inDegree.get(to) + 1);
            }
        }
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        for (Map.Entry entry : inDegree.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            arrayDeque.add((String)entry.getKey());
        }
        ArrayList<Plugin> sorted2 = new ArrayList<Plugin>();
        while (!arrayDeque.isEmpty()) {
            String string = (String)arrayDeque.remove();
            sorted2.add(nameToPlugin.get(string));
            for (String neighbor : (List)adj.get(string)) {
                inDegree.put(neighbor, (Integer)inDegree.get(neighbor) - 1);
                if ((Integer)inDegree.get(neighbor) != 0) continue;
                arrayDeque.add(neighbor);
            }
        }
        if (sorted2.size() != plugins.size()) {
            throw new IllegalStateException("Cyclic dependency detected among plugins!");
        }
        return sorted2;
    }

    @NotNull
    private @Unmodifiable List<String> getDirectDependencyNames(@NotNull Plugin plugin) {
        ArrayList deps = new ArrayList(plugin.getDescription().getDepend());
        deps.addAll(plugin.getDescription().getSoftDepend());
        return Collections.unmodifiableList(deps);
    }
}

