/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.virustotal.model.VTAnalysisResult;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.commands.arguments.LongStringArgument;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.kyori.adventure.text.Component;
import club.athlas.loademup.libs.kyori.adventure.text.TextComponent;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import club.athlas.loademup.utils.TagResolverUtils;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ScanCommand
extends SubCommand<LoadEmUp> {
    private final PluginLoader loader;

    public ScanCommand(LoadEmUp plugin) {
        super(plugin, "scan");
        this.loader = plugin.getLoader();
    }

    @Override
    public void setup() {
        this.withPermissions("loademup.command.scan");
        this.withArguments(new LongStringArgument("plugin").replaceSuggestions(commandSender -> this.loader.getPluginJarFiles().stream().map(File::getName).collect(Collectors.toList())));
        this.executes((sender, args2) -> {
            String jarFile = (String)args2.get("plugin");
            sender.sendMessage("\n");
            ((LoadEmUp)this.plugin).getVirusTotalIntegration().ifPresentOrElse(virusTotal -> this.loader.getPluginFile(jarFile).ifPresentOrElse(file -> {
                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.VIRUS_SCAN_START);
                virusTotal.runScan((File)file).whenComplete((uploadResponse, uploadErr) -> {
                    if (uploadErr != null) {
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.VIRUS_SCAN_UNABLE_TO_SCAN);
                        ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "[VirusTotal] Unable to scan " + jarFile, (Throwable)uploadErr);
                        return;
                    }
                    virusTotal.getAnalysisResult(uploadResponse.id()).whenComplete((vtAnalysisResult, getErr) -> {
                        if (getErr != null) {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.VIRUS_SCAN_NO_RESULT);
                            ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "[VirusTotal] Unable get result " + jarFile, (Throwable)getErr);
                            return;
                        }
                        List<VTAnalysisResult.AVResult> detections = vtAnalysisResult.results();
                        TagResolver[] placeholders = new TagResolver[]{Placeholder.component("list", this.getDetectionsList(detections)), TagResolverUtils.resolverFrom(vtAnalysisResult)};
                        if (detections.isEmpty()) {
                            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.VIRUS_SCAN_CLEAR, placeholders);
                            return;
                        }
                        ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.VIRUS_SCAN_THREATS_FOUND, placeholders);
                    });
                });
            }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.JAR_NOT_FOUND, Placeholder.parsed("file", jarFile))), () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.VIRUS_SCAN_SERVICE_DISABLED));
            sender.sendMessage("\n");
        });
    }

    @NotNull
    private Component getDetectionsList(@NotNull List<VTAnalysisResult.AVResult> results) {
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < results.size(); ++i) {
            VTAnalysisResult.AVResult avResult = results.get(i);
            builder.append(((LoadEmUp)this.plugin).getMessages().getComponent(LangKey.VIRUS_SCAN_RESULT_FORMAT, TagResolverUtils.resolverFrom(avResult)));
            if (i >= results.size() - 1) continue;
            builder.appendNewline();
        }
        return builder.build();
    }
}

