/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.commands.sub;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.constant.LEUAction;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.object.Dependency;
import club.athlas.loademup.api.object.PluginData;
import club.athlas.loademup.config.constant.LangKey;
import club.athlas.loademup.libs.commands.arguments.StringArgument;
import club.athlas.loademup.libs.commands.usable.SubCommand;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import club.athlas.loademup.server.commands.CommandCommons;
import club.athlas.loademup.utils.TagResolverUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class UnloadCommand
extends SubCommand<LoadEmUp> {
    private final PluginLoader loader;

    public UnloadCommand(LoadEmUp plugin) {
        super(plugin, "unload");
        this.loader = plugin.getLoader();
    }

    @Override
    public void setup() {
        this.withPermissions("loademup.command.unload");
        this.withArguments(new StringArgument("plugin").replaceSuggestions(commandSender -> this.loader.getPlugins().stream().map(Plugin::getName).collect(Collectors.toList())));
        this.executes((sender, args2) -> {
            String pluginName = (String)args2.get("plugin");
            sender.sendMessage("\n");
            this.loader.getPlugin(pluginName).ifPresentOrElse(targetPlugin -> {
                if (!CommandCommons.sendUnsupportedAction((LoadEmUp)this.plugin, LEUAction.UNLOAD, targetPlugin, sender)) {
                    return;
                }
                TagResolver placeholder = TagResolverUtils.resolverFrom(PluginData.from(targetPlugin));
                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.CHECKING_DEPENDENTS, placeholder);
                List<String> dependants = this.getAllDependentNames(this.loader, (Plugin)targetPlugin);
                if (!dependants.isEmpty() && !CommandCommons.hasArgFlags(args2, "--force")) {
                    ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_UNLOAD_BLOCKED, placeholder, TagResolverUtils.listPlaceholder("dependants", dependants));
                    return;
                }
                ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_UNLOAD_START, placeholder);
                this.unloadPlugin((Plugin)targetPlugin, sender);
                if (!CommandCommons.hasArgFlags(args2, "--unload-deps")) {
                    return;
                }
                dependants.stream().map(this.loader::getPlugin).filter(Optional::isPresent).forEach(dependant -> this.unloadPlugin((Plugin)dependant.get(), sender));
            }, () -> ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_NOT_FOUND, Placeholder.parsed("name", pluginName)));
            sender.sendMessage("\n");
        });
    }

    private void unloadPlugin(Plugin targetPlugin, CommandSender sender) {
        TagResolver placeholder = TagResolverUtils.resolverFrom(PluginData.from(targetPlugin));
        try {
            long start = System.currentTimeMillis();
            this.loader.unload(targetPlugin);
            long time = System.currentTimeMillis() - start;
            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_UNLOADED, placeholder, TagResolverUtils.resolverFromTime(time));
        }
        catch (Exception e) {
            ((LoadEmUp)this.plugin).getMessages().send(sender, LangKey.PLUGIN_UNLOAD_FAIL, Placeholder.parsed("error_msg", e.getMessage()));
            ((LoadEmUp)this.plugin).getLogger().log(Level.WARNING, "Failed to unload plugin " + targetPlugin.getName(), e);
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String @NotNull [] args2) {
        if (args2.length <= 1) {
            return super.onTabComplete(sender, command, alias, args2);
        }
        return List.of("--force", "--unload-deps");
    }

    @NotNull
    private List<String> getAllDependentNames(PluginLoader loader, Plugin rootPlugin) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        this.collectDependentNames(loader, rootPlugin, visited, result);
        result.remove(rootPlugin.getName());
        return result;
    }

    private void collectDependentNames(@NotNull PluginLoader loader, Plugin plugin, Set<String> visited, List<String> result) {
        for (Dependency dependant : loader.getDependents(plugin)) {
            String name;
            if (!dependant.isLoaded() || !visited.add(name = dependant.name())) continue;
            result.add(name);
            dependant.getPlugin().ifPresent(depPlugin -> this.collectDependentNames(loader, (Plugin)depPlugin, visited, result));
        }
    }
}

