/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.loader;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.exceptions.PluginAlreadyLoadedException;
import club.athlas.loademup.api.exceptions.PluginFileNotFoundException;
import club.athlas.loademup.api.loader.PluginLoader;
import club.athlas.loademup.api.object.Dependency;
import club.athlas.loademup.api.result.ClassLoaderValidationResult;
import club.athlas.loademup.api.utils.FileUtils;
import club.athlas.loademup.server.wrapper.WrappedInstanceManager;
import club.athlas.loademup.utils.ReflectionUtils;
import club.athlas.loademup.utils.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.PluginClassLoader;
import org.jetbrains.annotations.NotNull;

public abstract class BasePluginLoader
implements PluginLoader {
    protected final LoadEmUp plugin;
    protected final PluginManager pluginManager;

    protected BasePluginLoader(@NotNull LoadEmUp plugin, PluginManager pluginManager) {
        this.plugin = plugin;
        this.pluginManager = pluginManager;
    }

    protected BasePluginLoader(@NotNull LoadEmUp plugin) {
        this(plugin, plugin.getServer().getPluginManager());
    }

    @Override
    public Optional<Plugin> load(File file) throws InvalidPluginException, InvalidDescriptionException, PluginAlreadyLoadedException {
        if (this.isLoaded(file)) {
            throw new PluginAlreadyLoadedException(file);
        }
        Plugin loadedPlugin = this.pluginManager.loadPlugin(file);
        if (loadedPlugin == null) {
            return Optional.empty();
        }
        loadedPlugin.onLoad();
        this.enablePlugin(loadedPlugin);
        this.syncCommands();
        return Optional.of(loadedPlugin);
    }

    @Override
    public Optional<Plugin> load(Plugin plugin) throws InvalidPluginException, InvalidDescriptionException {
        Optional<File> fileOptional = this.getPluginFile(plugin);
        if (fileOptional.isEmpty()) {
            return Optional.empty();
        }
        return this.load(fileOptional.get());
    }

    @Override
    public Optional<Plugin> reload(Plugin plugin) throws InvalidPluginException, InvalidDescriptionException, PluginFileNotFoundException {
        if (this.getPluginFile(plugin).isEmpty()) {
            throw new PluginFileNotFoundException(plugin);
        }
        this.unload(plugin);
        return this.load(plugin);
    }

    @Override
    public Optional<Plugin> reloadFromCurrentJar(Plugin plugin) throws InvalidPluginException, InvalidDescriptionException, PluginFileNotFoundException {
        Optional<File> currentJar = this.getPluginCurrentJarInst(plugin);
        if (currentJar.isEmpty()) {
            throw new PluginFileNotFoundException(plugin);
        }
        this.unload(plugin);
        return this.load(currentJar.get());
    }

    @Override
    public boolean isLoaded(File file) {
        return this.getDescriptionFile(file).map(description -> this.pluginManager.getPlugin(description.getName()) != null).orElse(false);
    }

    @Override
    public void disablePlugin(@NotNull Plugin plugin) {
        if (!plugin.isEnabled()) {
            return;
        }
        this.stopPluginThreads(plugin);
        this.pluginManager.disablePlugin(plugin);
    }

    @Override
    public void enablePlugin(@NotNull Plugin plugin) {
        if (plugin.isEnabled()) {
            return;
        }
        this.pluginManager.enablePlugin(plugin);
    }

    @Override
    public boolean isEnabled(@NotNull Plugin plugin) {
        return plugin.isEnabled();
    }

    @Override
    public void reloadConfig(@NotNull Plugin plugin) {
        if (!plugin.isEnabled()) {
            return;
        }
        plugin.reloadConfig();
    }

    @Override
    public Set<Plugin> getPlugins() {
        return Set.of(this.pluginManager.getPlugins());
    }

    @Override
    public Optional<Plugin> getPlugin(@NotNull String name) {
        return Optional.ofNullable(this.pluginManager.getPlugin(name));
    }

    @Override
    public List<Dependency> getMissingDependencies(@NotNull PluginDescriptionFile description) {
        return this.getDependencies(description).stream().filter(dependency -> dependency.required() && !dependency.isLoaded()).collect(Collectors.toList());
    }

    @Override
    public List<Dependency> getMissingDependencies(@NotNull File file) {
        return this.getDescriptionFile(file).map(this::getMissingDependencies).orElse(Collections.emptyList());
    }

    @Override
    public List<Dependency> getDependencies(@NotNull File file) {
        return this.getDescriptionFile(file).map(this::getDependencies).orElse(Collections.emptyList());
    }

    /*
     * Loose catch block
     */
    @Override
    public Optional<PluginDescriptionFile> getDescriptionFile(File file) {
        Optional<PluginDescriptionFile> optional;
        InputStream is;
        JarFile jar;
        block20: {
            JarEntry entry;
            block19: {
                if (!FileUtils.isJarFile(file)) {
                    return Optional.empty();
                }
                jar = new JarFile(file);
                entry = jar.getJarEntry("plugin.yml");
                if (entry != null) break block19;
                Optional<PluginDescriptionFile> optional2 = Optional.empty();
                jar.close();
                return optional2;
            }
            is = jar.getInputStream(entry);
            optional = Optional.of(new PluginDescriptionFile(is));
            if (is == null) break block20;
            is.close();
        }
        jar.close();
        return optional;
        {
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidDescriptionException e) {
                    Optional<PluginDescriptionFile> optional3 = Optional.empty();
                    jar.close();
                    return optional3;
                }
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                        catch (IOException e) {
                            return Optional.empty();
                        }
                    }
                }
            }
        }
    }

    @Override
    public Optional<File> getPluginCurrentJarInst(Plugin plugin) {
        try {
            URL jarUrl = plugin.getClass().getProtectionDomain().getCodeSource().getLocation();
            if (jarUrl == null) {
                return Optional.empty();
            }
            return Optional.of(new File(jarUrl.toURI()));
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to get current jar", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<File> getPluginFile(Plugin plugin) {
        try {
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            if (!(classLoader instanceof PluginClassLoader)) {
                return Optional.empty();
            }
            PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader;
            File file = (File)ReflectionUtils.accessField(pluginClassLoader, "file");
            if (file == null) {
                return Optional.empty();
            }
            return Optional.of(file);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<File> getPluginFile(String name) {
        try {
            File pluginFile = new File(this.getPluginsFolder(), name);
            return pluginFile.exists() ? Optional.of(pluginFile) : Optional.empty();
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Set<File> getPluginJarFiles() {
        return Arrays.stream(Objects.requireNonNull(this.getPluginsFolder().listFiles())).filter(File::isFile).filter(file -> FileUtils.isJarFile(file) && this.getDescriptionFile((File)file).isPresent()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public File getPluginsFolder() {
        return this.plugin.getServer().getPluginsFolder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassLoaderValidationResult validateClassLoader(File file) {
        Optional<PluginDescriptionFile> descOpt = this.getDescriptionFile(file);
        if (descOpt.isEmpty()) {
            return ClassLoaderValidationResult.MISSING_PLUGIN_DESCRIPTION;
        }
        PluginDescriptionFile desc = descOpt.get();
        try (URLClassLoader testLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, Bukkit.class.getClassLoader());){
            Class<?> mainClass = testLoader.loadClass(desc.getMain());
            if (!Plugin.class.isAssignableFrom(mainClass)) {
                ClassLoaderValidationResult classLoaderValidationResult = ClassLoaderValidationResult.INVALID_MAIN_CLASS;
                return classLoaderValidationResult;
            }
            try {
                mainClass.getDeclaredConstructor(new Class[0]);
                return ClassLoaderValidationResult.VALID;
            }
            catch (NoSuchMethodException e) {
                ClassLoaderValidationResult classLoaderValidationResult = ClassLoaderValidationResult.INVALID_MAIN_CLASS;
                testLoader.close();
                return classLoaderValidationResult;
            }
        }
        catch (MalformedURLException e) {
            return ClassLoaderValidationResult.FILE_NOT_FOUND;
        }
        catch (ClassNotFoundException e) {
            return ClassLoaderValidationResult.NO_MAIN_CLASS;
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to close test class loader", e);
            return ClassLoaderValidationResult.UNEXPECTED_ERROR;
        }
    }

    protected void syncCommands() {
        try {
            ReflectionUtils.callMethod((Object)Bukkit.getServer(), "syncCommands", new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected void cleanup(@NotNull WrappedInstanceManager instanceManager, Plugin plugin) {
        Map<String, Command> knownCommands = instanceManager.getCommandMap().getKnownCommands();
        instanceManager.getPlugins().remove(plugin);
        instanceManager.getLookupNames().remove(plugin.getName());
        instanceManager.getLookupNames().remove(plugin.getName().toLowerCase());
        HandlerList.unregisterAll((Plugin)plugin);
        Set<String> keysToRemove = knownCommands.entrySet().stream().filter(e -> {
            PluginCommand pluginCommand;
            Object patt10034$temp = e.getValue();
            return patt10034$temp instanceof PluginCommand && (pluginCommand = (PluginCommand)patt10034$temp).getPlugin().equals(plugin);
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        keysToRemove.forEach(knownCommands::remove);
        Bukkit.getScheduler().cancelTasks(plugin);
        Bukkit.getServicesManager().unregisterAll(plugin);
        this.closeClassLoader(plugin);
        this.syncCommands();
        System.gc();
    }

    protected void closeClassLoader(@NotNull Plugin plugin) {
        try {
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                urlClassLoader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void stopPluginThreads(Plugin target) {
        Set<Thread> threads = ThreadUtils.getThreadsFromPlugin(target);
        if (threads.isEmpty()) {
            return;
        }
        this.plugin.getLogger().info("Interrupting " + threads.size() + " thread(s) for plugin: " + this.plugin.getName());
        for (Thread thread2 : threads) {
            try {
                this.plugin.getLogger().warning("Interrupting thread: " + thread2.getName());
                thread2.interrupt();
                thread2.join(2000L);
                if (thread2.isAlive()) {
                    this.plugin.getLogger().warning("Thread is still alive after interruption: " + thread2.getName());
                    continue;
                }
                this.plugin.getLogger().info("Thread stopped cleanly: " + thread2.getName());
            }
            catch (Throwable t) {
                this.plugin.getLogger().log(Level.SEVERE, "Error while stopping thread: " + thread2.getName(), t);
            }
        }
    }
}

