/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.loader;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.object.Dependency;
import club.athlas.loademup.api.platform.DefPlatform;
import club.athlas.loademup.server.loader.BasePluginLoader;
import club.athlas.loademup.server.wrapper.PaperPluginInstanceManager;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.plugin.provider.PluginProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class PaperPluginLoader
extends BasePluginLoader {
    private final PaperPluginInstanceManager instanceManager;

    public PaperPluginLoader(LoadEmUp plugin) {
        super(plugin, (PluginManager)PaperPluginManagerImpl.getInstance());
        try {
            this.instanceManager = new PaperPluginInstanceManager(PaperPluginManagerImpl.getInstance());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public PaperPluginLoader(LoadEmUp plugin, PaperPluginManagerImpl paperPluginManagerImpl) {
        super(plugin, (PluginManager)paperPluginManagerImpl);
        try {
            this.instanceManager = new PaperPluginInstanceManager(paperPluginManagerImpl);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unload(Plugin plugin) {
        Map storage = LaunchEntryPointHandler.INSTANCE.getStorage();
        this.disablePlugin(plugin);
        storage.values().forEach(providerStorage -> {
            Iterator providerIterator = providerStorage.getRegisteredProviders().iterator();
            while (providerIterator.hasNext()) {
                PluginProvider provider = (PluginProvider)providerIterator.next();
                if (!provider.getMeta().getName().equals(plugin.getName())) continue;
                providerIterator.remove();
            }
        });
        this.cleanup(this.instanceManager, plugin);
    }

    @Override
    public List<Dependency> getDependents(@NotNull Plugin plugin) {
        ArrayList<Dependency> dependentPlugins = new ArrayList<Dependency>();
        String targetName = plugin.getName();
        for (Plugin checked : Bukkit.getPluginManager().getPlugins()) {
            this.getDependencies(checked).stream().filter(dependency -> dependency.name().equals(targetName)).findFirst().ifPresent(dependency -> dependentPlugins.add(new Dependency(checked.getName(), dependency.required(), DefPlatform.PAPER)));
        }
        return dependentPlugins;
    }

    @Override
    public List<Dependency> getDependencies(@NotNull PluginDescriptionFile description) {
        return this.getPluginDependencies((PluginMeta)description);
    }

    @Override
    public List<Dependency> getDependencies(@NotNull Plugin plugin) {
        return this.getPluginDependencies(plugin.getPluginMeta());
    }

    @NotNull
    private List<Dependency> getPluginDependencies(@NotNull PluginMeta meta) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        meta.getPluginDependencies().forEach(dependency -> dependencies.add(new Dependency((String)dependency, true, DefPlatform.PAPER)));
        meta.getPluginSoftDependencies().forEach(dependency -> dependencies.add(new Dependency((String)dependency, false, DefPlatform.PAPER)));
        return dependencies;
    }
}

