/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.server.loader;

import club.athlas.loademup.LoadEmUp;
import club.athlas.loademup.api.object.Dependency;
import club.athlas.loademup.api.platform.DefPlatform;
import club.athlas.loademup.server.loader.BasePluginLoader;
import club.athlas.loademup.server.wrapper.SpigotPluginInstanceManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;
import org.jetbrains.annotations.NotNull;

public class SpigotPluginLoader
extends BasePluginLoader {
    private final SpigotPluginInstanceManager instanceManager;

    public SpigotPluginLoader(LoadEmUp plugin) {
        super(plugin);
        try {
            this.instanceManager = new SpigotPluginInstanceManager((SimplePluginManager)Bukkit.getPluginManager());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public SpigotPluginLoader(LoadEmUp plugin, SimplePluginManager pluginManager) {
        super(plugin, (PluginManager)pluginManager);
        try {
            this.instanceManager = new SpigotPluginInstanceManager(pluginManager);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unload(Plugin plugin) {
        this.disablePlugin(plugin);
        this.cleanup(this.instanceManager, plugin);
    }

    @Override
    public List<Dependency> getDependents(@NotNull Plugin plugin) {
        ArrayList<Dependency> dependentPlugins = new ArrayList<Dependency>();
        String targetName = plugin.getName();
        for (Plugin checked : Bukkit.getPluginManager().getPlugins()) {
            this.getDependencies(checked).stream().filter(dependency -> dependency.name().equals(targetName)).findFirst().ifPresent(dependency -> dependentPlugins.add(new Dependency(checked.getName(), dependency.required(), DefPlatform.SPIGOT)));
        }
        return dependentPlugins;
    }

    @Override
    public List<Dependency> getDependencies(@NotNull PluginDescriptionFile description) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        description.getDepend().forEach(dependency -> dependencies.add(new Dependency((String)dependency, true, DefPlatform.SPIGOT)));
        description.getSoftDepend().forEach(dependency -> dependencies.add(new Dependency((String)dependency, false, DefPlatform.SPIGOT)));
        return dependencies;
    }

    @Override
    public List<Dependency> getDependencies(@NotNull Plugin plugin) {
        return this.getDependencies(plugin.getDescription());
    }
}

