/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.utils;

import club.athlas.loademup.utils.TypeReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtils {
    public static <T> T accessField(@NotNull Object object, String fieldName, TypeReference<T> typeRef) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(fieldName);
        boolean accessible = ReflectionUtils.isAccessible(object, field);
        if (!accessible) {
            field.setAccessible(true);
        }
        Object value = field.get(object);
        if (ReflectionUtils.isAccessible(object, field) != accessible) {
            field.setAccessible(accessible);
        }
        return (T)value;
    }

    public static <T> T accessField(@NotNull Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionUtils.accessField(object, fieldName, new TypeReference<T>(){});
    }

    public static <T> T accessFieldFromType(@NotNull Class<?> type, @NotNull Object object, String fieldName, TypeReference<T> typeRef) throws NoSuchFieldException, IllegalAccessException {
        Field field = type.getDeclaredField(fieldName);
        boolean accessible = ReflectionUtils.isAccessible(object, field);
        if (!accessible) {
            field.setAccessible(true);
        }
        Object value = field.get(object);
        if (ReflectionUtils.isAccessible(object, field) != accessible) {
            field.setAccessible(accessible);
        }
        return (T)value;
    }

    public static <T> T accessFieldFromType(@NotNull Class<?> type, @NotNull Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionUtils.accessFieldFromType(type, object, fieldName, new TypeReference<T>(){});
    }

    public static <T> T callMethod(@NotNull Object object, @NotNull String methodName, @NotNull TypeReference<T> typeRef, Object ... args2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class[] paramTypes = (Class[])Arrays.stream(args2).map(arg -> arg != null ? arg.getClass() : Object.class).toArray(Class[]::new);
        Method method = object.getClass().getDeclaredMethod(methodName, paramTypes);
        boolean accessible = ReflectionUtils.isAccessible(object, method);
        if (!accessible) {
            method.setAccessible(true);
        }
        Object result = method.invoke(object, args2);
        if (ReflectionUtils.isAccessible(object, method) != accessible) {
            method.setAccessible(accessible);
        }
        return (T)result;
    }

    public static <T> T callMethod(@NotNull Object object, @NotNull String methodName, Object ... args2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectionUtils.callMethod(object, methodName, new TypeReference<T>(){}, args2);
    }

    public static boolean isAccessible(@NotNull Object object, @NotNull Field field) {
        return ReflectionUtils.isPublic(field.getModifiers()) && ReflectionUtils.isPublic(field.getDeclaringClass().getModifiers());
    }

    public static boolean isAccessible(@NotNull Object object, @NotNull Method method) {
        return ReflectionUtils.isPublic(method.getModifiers()) && ReflectionUtils.isPublic(method.getDeclaringClass().getModifiers());
    }

    private static boolean isPublic(int modifiers) {
        return Modifier.isPublic(modifiers);
    }
}

