/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.utils;

import club.athlas.loademup.api.object.PluginData;
import club.athlas.loademup.api.virustotal.model.VTAnalysisResult;
import club.athlas.loademup.libs.commands.utility.helpers.HelpValue;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.Tag;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.TagPattern;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import club.athlas.loademup.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TagResolverUtils {
    @Contract(value="_, _ -> new")
    @NotNull
    public static TagResolver resolverFrom(PluginData data, @TagPattern String placeholder) {
        return TagResolver.resolver(placeholder, (args2, ctx) -> {
            String value;
            String param;
            switch (param = args2.popOr("param expected").value()) {
                case "name": {
                    String string = data.name();
                    break;
                }
                case "description": {
                    String string = data.description();
                    break;
                }
                case "author": {
                    String string = data.authors().toString();
                    break;
                }
                case "version": {
                    String string = data.version();
                    break;
                }
                default: {
                    String string = value = "<red>invalid param";
                }
            }
            if (value == null) {
                value = "null";
            }
            return Tag.preProcessParsed(value);
        });
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TagResolver resolverFrom(PluginData data) {
        return TagResolverUtils.resolverFrom(data, "plugin");
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TagResolver resolverFrom(HelpValue helpValue) {
        return TagResolver.resolver("helpvalue", (args2, ctx) -> {
            String param;
            String value = switch (param = args2.popOr("param expected").value()) {
                case "command" -> helpValue.getCommand();
                case "description" -> helpValue.getDescription();
                case "permission" -> helpValue.getPermission().getPermission();
                default -> "<red>invalid param";
            };
            return Tag.preProcessParsed(value);
        });
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TagResolver resolverFrom(VTAnalysisResult avResult) {
        return TagResolver.resolver("detections", (args2, ctx) -> {
            String param;
            String value = switch (param = args2.popOr("param expected").value()) {
                case "status" -> avResult.status();
                case "count" -> String.valueOf(avResult.detections().size());
                default -> "<red>invalid param";
            };
            return Tag.preProcessParsed(value);
        });
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TagResolver resolverFrom(VTAnalysisResult.AVResult avResult) {
        return TagResolver.resolver("detection", (args2, ctx) -> {
            String param;
            String value = switch (param = args2.popOr("param expected").value()) {
                case "engine" -> avResult.engine();
                case "version" -> avResult.version();
                case "verdict" -> avResult.verdict().name();
                case "type" -> avResult.type();
                case "method" -> avResult.method();
                case "severity" -> avResult.severity().name();
                default -> "<red>invalid param";
            };
            return Tag.preProcessParsed(value);
        });
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TagResolver resolverFromTime(long millis) {
        return TagResolver.resolver("time", (args2, ctx) -> {
            String unit;
            return Tag.preProcessParsed((String)(switch (unit = args2.popOr("time unit expected").value().toLowerCase()) {
                case "millis" -> {
                    long value = millis;
                    yield Long.toString(value);
                }
                case "seconds" -> {
                    long value = TimeUnit.MILLISECONDS.toSeconds(millis);
                    yield value + "s";
                }
                case "minutes" -> {
                    long value = TimeUnit.MILLISECONDS.toMinutes(millis);
                    yield value + "m";
                }
                case "hours" -> {
                    long value = TimeUnit.MILLISECONDS.toHours(millis);
                    yield value + "h";
                }
                case "days" -> {
                    long value = TimeUnit.MILLISECONDS.toDays(millis);
                    yield value + "d";
                }
                case "compact" -> {
                    long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
                    long minutes = seconds / 60L;
                    long hours = minutes / 60L;
                    long days = hours / 24L;
                    seconds %= 60L;
                    minutes %= 60L;
                    hours %= 24L;
                    StringBuilder sb = new StringBuilder();
                    if (days > 0L) {
                        sb.append(days).append("d ");
                    }
                    if (hours > 0L) {
                        sb.append(hours).append("h ");
                    }
                    if (minutes > 0L) {
                        sb.append(minutes).append("m ");
                    }
                    if (seconds > 0L || sb.isEmpty()) {
                        sb.append(seconds).append("s");
                    }
                    yield sb.toString().trim();
                }
                default -> "<red>invalid unit";
            }));
        });
    }

    @NotNull
    public static TagResolver listPlaceholder(@TagPattern String tag, Collection<String> collection) {
        return Placeholder.parsed(tag, String.join((CharSequence)", ", collection));
    }
}

