/*
 * Decompiled with CFR 0.152.
 */
package club.athlas.loademup.utils;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadUtils {
    private static final Set<String> KNOWN_THREAD_PREFIXES = Set.of("Craft", "Netty", "Paper", "Async Chat", "Server thread", "ForkJoinPool");

    @NotNull
    public static Set<Thread> getAllThreads() {
        return Thread.getAllStackTraces().keySet();
    }

    public static boolean isThreadFromPlugin(@NotNull Thread thread2, @NotNull Plugin plugin) {
        ClassLoader pluginClassLoader = plugin.getClass().getClassLoader();
        if (pluginClassLoader.equals(thread2.getClass().getClassLoader())) {
            return true;
        }
        Runnable target = ThreadUtils.getRunnableTarget(thread2);
        return target != null && pluginClassLoader.equals(target.getClass().getClassLoader());
    }

    @NotNull
    public static Set<Thread> getThreadsFromPlugin(Plugin plugin) {
        HashSet<Thread> result = new HashSet<Thread>();
        for (Thread thread2 : ThreadUtils.getAllThreads()) {
            if (!ThreadUtils.isThreadFromPlugin(thread2, plugin) || ThreadUtils.isSystemThread(thread2)) continue;
            result.add(thread2);
        }
        return result;
    }

    @Nullable
    private static Runnable getRunnableTarget(Thread thread2) {
        try {
            Field targetField = Thread.class.getDeclaredField("target");
            targetField.setAccessible(true);
            Object target = targetField.get(thread2);
            if (target instanceof Runnable) {
                return (Runnable)target;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isSystemThread(Thread thread2) {
        for (String prefix : KNOWN_THREAD_PREFIXES) {
            if (!thread2.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

